#!/usr/bin/perl

use Direct::Modern;
use lib '/var/www/ppc.yandex.ru/';
use my_inc '/var/www/ppc.yandex.ru', for => 'protected';
use Path::Tiny;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Clickhouse;

my $p = path('~/tmp/black-list-2016.csv');
my @domains = map { s!\s!!gr } $p->lines({ chomp => 1 });

my $query = qq#
select distinct domain
from banners 
all inner join campaigns using cid
where 1=1
#
."and domain in (".( join ",", map { "'$_'" } @domains).")"
."
and lastShowTime > toDateTime('2015-09-04 00:00:00')
";

my $clh = Yandex::Clickhouse->new(
    host => 'ppchouse01i',
    settings => {
        database => 'ppc',
    },
);

my $res = $clh->query($query)->tsv;
for my $row (@$res) {
    print $row->[0]."\n";
}
