#!/usr/bin/perl

use Direct::Modern;
use lib '/var/www/ppc.yandex.ru/';
use my_inc '/var/www/ppc.yandex.ru', for => 'protected';
use Path::Tiny;
use Yandex::DBTools;
use Yandex::DBShards;
BEGIN {
    $ENV{SETTINGS_LOCAL_SUFFIX} = 'ROProd';
};
use Settings;
# die $Settings::CONFIGURATION;
use geo_regions;
use GeoTools qw/get_geo_projection/;

my $p = path('~/tmp/forex4.txt');
my @bids = $p->lines({chomp => 1});
my $rows = get_all_sql(PPC(bid => \@bids), [
    "select b.bid, p.geo
    from banners b
    join phrases p on p.pid = b.pid",
    where => {
        'b.bid' => SHARD_IDS,
    },
    # "limit 10",
]);

for my $row (@$rows) {
    my @geo = grep { /^\d+$/ } split /,/, ($row->{geo}//'');
    next unless @geo;
    for my $geo (@geo) {
        if ((get_geo_projection($geo, { type => $geo_regions::COUNTRY })//0) == $geo_regions::BY) {
            print "$row->{bid}\t$row->{geo}\n";
        }
    }
}
