#!/usr/bin/perl

use Direct::Modern;

use DDP;

use Yandex::DBTools;
use Yandex::Log;

$Yandex::Log::LOG_ROOT = '/home/ppalex/logs/';

use my_inc q!/home/ppalex/trunk!, for => 'protected';

use RBAC2::Extended;
use RBACDirect;
use RBACElementary;
INIT { $Settings::LOCK_ROOT = '/home/ppalex/tmp'; }
use ScriptHelper;
use Settings;
use ShardingTools;
use User;

$Yandex::DBTools::QUERIES_LOG = undef;
$ScriptHelper::is_beta = 1;

use open ':std' => ':utf8';

$log->out('START');

my @clients;
for my $SHARD (ppc_shards()) {
    $log->out("fetch clients from shard $SHARD");
    my $cl = get_one_column_sql(PPC(shard => $SHARD), [
            'SELECT /* one-off-stat */ u.ClientID FROM users u',
                'JOIN client_firm_country_currency cfcc ON cfcc.ClientID = u.ClientID',
                'LEFT JOIN clients cl ON cl.ClientID = u.ClientID',
                'LEFT JOIN users_options uo ON uo.uid = u.uid',
            'WHERE IFNULL(cl.work_currency, "YND_FIXED") = "YND_FIXED"',
                'AND IFNULL(uo.statusEasy, "No") = "No"',
            'GROUP BY u.ClientID',
            'HAVING COUNT(DISTINCT cfcc.country_region_id) = 1',
                'AND COUNT(DISTINCT cfcc.currency) = 1',
                'AND SUM(IF(cfcc.currency = "KZT", 1, 0)) > 0',
        ]);
    $log->out("got " . scalar(@$cl) . " clients");

    push @clients, @$cl;
}

my $rbac = RBAC2::Extended->get_singleton( 1 ) or $log->die("can't get rbac");

$log->out('fetch chief reps');
my $cl2uid = rbac_get_chief_reps_of_clients($rbac, \@clients);

$log->out('fetch has_agency');
my $uid2has_ag = rbac_mass_has_agency($rbac, [values %$cl2uid]);

$log->out('fetch rbac who_is');
my $who = rbac_multi_who_is($rbac, [values %$cl2uid]);

$log->out('fetch users data');
my $users = get_users_data([values %$cl2uid], [qw/login email fio/]);

$log->out('process data');
print join("\t", qw/login email fio/), "\n";
for my $clientid (@clients) {
    my $uid = $cl2uid->{$clientid};

    if (!$uid) {
        $log->out("no uid for clientid $clientid, skip");
        next;
    }

    if ($who->{$uid} ne 'client') {
        $log->out("clientid $clientid, uid $uid not client: $who->{$uid}, skip");
        next;
    }

    if ($uid2has_ag->{$uid}) {
        $log->out("clientid $clientid has agency, skip");
        next;
    }

    print join("\t", map {$_ || '???' } @{ $users->{$uid} }{qw/login email fio/}), "\n";
}

$log->out('FINISH');
