#!/usr/bin/perl

use Direct::Modern;
use lib '/var/www/ppc.yandex.ru/';
use my_inc '/var/www/ppc.yandex.ru', for => 'protected';
BEGIN { $ENV{SETTINGS_LOCAL_SUFFIX} = 'ROProd'; }
use Settings;
use Yandex::DBTools;
use Yandex::Overshard;

my $rows = overshard
    sum => 'cnt_active,cnt_all',
    group => 'image_type',
    get_all_sql(PPC(shard => 'all'), qq#
        select
            image_type,
            sum(if(statusActive = 'Yes',1,0)) as cnt_active,
            sum(1) as cnt_all
        from banner_images_formats bimf
        join banner_images bim using(image_hash)
        join banners b using(bid)
        where image_type in ('regular','wide')
        group by image_type
#);

print "image_type\tcnt_active\tcnt_all\n";
for my $row (@$rows) {
    print "$row->{image_type}\t$row->{cnt_active}\t$row->{cnt_all}\n";
}

