#!/usr/bin/perl

# https://st.yandex-team.ru/DIRECT-52282
# Нужна выгрузка всех адресов из РК Директа (Баян не считаем), таргетированных на Россию, где были показы в последние полгода. Нужны ФИО и e-mail'ы.
# архивные кампании не считаем

# запускать на бете с конфигурацией roprod
# пишет csv на stdout
# для выходного файла надо сделать sort | uniq
# дата "полгода назад" захардкожена

use Direct::Modern;

use open qw/:std :encoding(UTF-8)/;

use List::Util qw/min max/;
use Text::CSV;

use my_inc '..';

use Settings;
use Yandex::DBTools;

my $csv = Text::CSV->new({binary => 1});
my $min_cid = min @{ get_one_column_sql(PPC(shard => 'all'), 'SELECT MIN(cid) FROM campaigns') };
my $max_cid = min @{ get_one_column_sql(PPC(shard => 'all'), 'SELECT MAX(cid) FROM campaigns') };

my $chunk_size = 100_000;
my $min_last_show_time = "2015-09-21";  # полгода назад

print "fio,email\n";
while ($max_cid > $min_cid + $chunk_size) {
    print STDERR "selecting from $min_cid to " . ($min_cid + $chunk_size) . "\n";
    my $data = get_all_sql(PPC(shard => 'all'), ['SELECT DISTINCT(uid), fio, email FROM users JOIN campaigns USING(uid)', where => {
                lastShowTime__ge => $min_last_show_time,
                archived => 'No',
                type__ne => 'mcb',
                type__ne => 'geo',
                cid__between => [$min_cid, $min_cid + $chunk_size],
               }]);
    $csv->print(\*STDOUT, [$_->{fio}, $_->{email}]) && print "\n" for @$data;
    $min_cid += ($chunk_size + 1);
}
