#!/usr/bin/perl

use Direct::Modern;

use DDP;

use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Log;

$Yandex::Log::LOG_ROOT = '/home/ppalex/logs/';

use my_inc q!/home/ppalex/trunk!, for => 'protected';

use Campaign::Types;
use geo_regions ();
use RBAC2::Extended;
use RBACDirect;
use RBACElementary;
INIT { $Settings::LOCK_ROOT = '/home/ppalex/tmp'; }
use ScriptHelper;
use Settings;
use ShardingTools;
use User;

$Yandex::DBTools::QUERIES_LOG = undef;
$ScriptHelper::is_beta = 1;

use open ':std' => ':utf8';

$log->out('START');

my $rbac = RBAC2::Extended->get_singleton( 1 ) or $log->die("can't get rbac");

$log->out('fetch all agency uids');
my $ag_uids = rbac_get_all_agencies($rbac);

$log->out('filter by country');
my $rus_ag_uids = get_hash_sql(PPC(uid => $ag_uids), [
                                    'SELECT u.uid, u.ClientID',
                                    'FROM users u',
                                    'JOIN client_firm_country_currency cfcc ON cfcc.ClientID = u.ClientID',
                                    WHERE => {
                                        'u.uid__int' => SHARD_IDS,
                                    },
                                    'GROUP BY u.uid',
                                    'HAVING COUNT(DISTINCT cfcc.country_region_id) = 1',
                                    'AND COUNT(DISTINCT cfcc.currency) = 1',
                                    "AND MAX(cfcc.country_region_id) = $geo_regions::RUS",
                              ]);
undef $ag_uids;
$log->out("got " . scalar(keys %$rus_ag_uids) . " agency uids");

my %STAT;
for my $shard (ppc_shards()) {
    for my $chunk (chunks([nsort keys %$rus_ag_uids], 10_000)) {
        $log->out("fetching client campaigns count chunk in shard $shard");
        my $st_ch = get_hash_sql(PPC(shard => $shard), [
                                    'SELECT c.AgencyUID, COUNT(*)',
                                    'FROM campaigns c',
                                    'JOIN users u ON u.uid = c.uid',
                                    'JOIN clients_to_force_multicurrency_teaser cfmt ON cfmt.ClientID = u.ClientID',
                                    'LEFT JOIN clients cl ON cl.ClientID = u.ClientID',
                                    WHERE => {
                                        'c.AgencyUID__int' => $chunk,
                                        'c.type' => get_camp_kind_types('currency_convert'),
                                        'c.statusEmpty' => 'No',
                                        _TEXT => 'IFNULL(cl.work_currency, "YND_FIXED") = "YND_FIXED"',
                                    },
                                    'GROUP BY AgencyUID',
                                ]);

        for my $uid (keys %$st_ch) {
            my $ClientID = $rus_ag_uids->{$uid};
            $STAT{$ClientID} += $st_ch->{$uid};
        }
    }
}

my @sorted = sort { $STAT{$b} <=> $STAT{$a} } keys %STAT;
my @top = @sorted[0..29];
$log->out("fetch top agency chiefs");
my $cl2uid = rbac_get_chief_reps_of_agencies($rbac, \@top);
$log->out('fetch agencies data');
my $users = get_users_data([values %$cl2uid], [qw/login email fio/]);

print "#|\n";
print "| Количество кампаний | ClientID | login | email | fio |\n";
for my $ClientID (@top) {
    my $data = $users->{$cl2uid->{$ClientID}};
    print "|| $STAT{$ClientID} | $ClientID | $data->{login} | $data->{email} | $data->{fio} ||\n";
}
print "|#\n";

$log->out('FINISH');
