#!/usr/bin/perl

=for none

./xls-uploads.pl 2>STDERR >uploads.csv

работает пару минут

=cut

use Direct::Modern;
use lib '/var/www/ppc.yandex.ru/';
use my_inc '/var/www/ppc.yandex.ru', for => 'protected';
BEGIN { $ENV{SETTINGS_LOCAL_SUFFIX} = 'ROProd'; }

use Yandex::DBTools;
use Yandex::Retry qw/relaxed_guard retry/;
use Yandex::TimeCommon;

use PrimitivesIds;
use Settings;

my $START_DATE = "2015-12-01";
#my $END_DATE = "2015-12-28";
my $END_DATE = "2016-03-28";
my $N = 1;

run() unless caller();

sub run
{
    my @dates = map {s/^(\d{4})(\d{2})(\d{2})$/$1-$2-$3/r or die "bad date $_"} get_distinct_dates($START_DATE, $END_DATE);
    my @fields = qw/date uid ClientID cnt sum_units sum_edit_banner sum_create_banner sum_edit_phrase sum_create_phrase /;
    print join " ", @fields;
    print "\n";

    while ( @dates ){
        my $guard = relaxed_guard times => 2;
        my @date_chunk = splice(@dates,0,$N);
        my $s = "$date_chunk[0] 00:00:00";
        my $e = "$date_chunk[-1] 23:59:59";
        print STDERR localtime()." $s .. $e\n";
=for none
| units         | int(10) unsigned  | NO   |     | NULL              |       |
| edit_banner   | int(10) unsigned  | NO   |     | NULL              |       |
| create_banner | int(10) unsigned  | NO   |     | NULL              |       |
| edit_phrase   | int(10) unsigned  | NO   |     | NULL              |       |
| create_phrase | int(10) unsigned  | NO   |     | NULL              |       |

=cut
        my $stat = get_all_sql(PPCLOG, "select 
            date(logdate) as date, 
            uid, 
            count(*) as cnt, 
            sum(units) as sum_units,
            sum(edit_banner) as sum_edit_banner,
            sum(create_banner) as sum_create_banner,
            sum(edit_phrase) as sum_edit_phrase,
            sum(create_phrase) as sum_create_phrase
            from log_xls_users_units
            where logdate >= ?
                and logdate <= ?
            group by 1,2 
            order by 1,2
            ",
            $s, $e
        );
        add_clientid($stat);
        for my $r ( @$stat ){
            print join " ", map { $r->{$_} } @fields;
            print "\n";
        }
    }

    exit 0;
}

sub add_clientid
{
    my ($stat) = @_;
    state %ClientID;

    my @uids = map {$_->{uid}} grep {!exists $ClientID{$_}} @$stat;

    my $new_cl_id = get_uid2clientid(uid => \@uids);
    for my $uid (keys %$new_cl_id){
        $ClientID{$uid} = $new_cl_id->{$uid};
    }

    for my $r (@$stat){
        $r->{ClientID} = $ClientID{$r->{uid}} || '0';
    }

    return;
}

