#!/usr/bin/perl

=for none

бету из my_inc надо переключить на roprod

=cut

use strict;
use warnings;

use my_inc '/var/www/beta.lena-san.9003', for => 'protected';

use YAML;

use E;

use utf8;
use open ":std" => ":utf8";


my $type = "manager";#"agency";

my @fields;

if ( $type eq "agency" ){
    @fields = qw/ client_login agency_login agency_fio agency_email manager_login manager_email cids/;
} elsif ( $type eq "manager" ){
    @fields = qw/ client_login client_email client_fio manager_login manager_email cids/;
} else {
    die;
}

run() unless caller();


sub run
{
    my %AGENCY_ID_TO_MANAGER_UID;
    my @data;
    print join "\t", @fields;
    print "\n";
    while ( my $line = <> ){
       my ($agency_id, $uid, $cids, $manager_uid, $main_agency_uid);
       if ($type eq "agency"){
           ($agency_id, $uid, $cids) = split /\s+/, $line;
           $manager_uid = agency_id_to_manager_uid($agency_id);
           $main_agency_uid = rbac_get_chief_rep_of_agency($rbac, $agency_id);
       } elsif ( $type eq "manager" ) {
           ($manager_uid, $uid, $cids) = split /\s+/, $line;
           $main_agency_uid = 0;
       } else {
           die;
       }
       push @data, {
           agency_uid => $main_agency_uid,
           manager_uid => $manager_uid,
           client_uid => $uid, 
           cids => $cids,
       };
       flush(\@data) if @data > 500; 
    }
    flush(\@data);
}

sub flush 
{
    my ($data) = @_;
    print STDERR localtime." flush\n";
    my $u = get_users_list_info([map { $_->{agency_uid}, $_->{manager_uid}, $_->{client_uid} } @$data]);
    for my $d (@$data){
        $d->{agency_login} = $u->{$d->{agency_uid}}->{login};
        $d->{manager_login} = $u->{$d->{manager_uid}}->{login};
        $d->{client_login} = $u->{$d->{client_uid}}->{login};

        $d->{agency_fio} = $u->{$d->{agency_uid}}->{FIO};
        $d->{client_fio} = $u->{$d->{client_uid}}->{FIO};

        $d->{agency_email} = $u->{$d->{agency_uid}}->{email};
        $d->{manager_email} = $u->{$d->{manager_uid}}->{email};
        $d->{client_email} = $u->{$d->{client_uid}}->{email};
        print join "\t", map {$d->{$_}//'NONE-NONE'} @fields; 
        print "\n";
    }

    @$data = ();
}


sub agency_id_to_manager_uid
{
    my ($client_id) = @_;
    my %M;

    $M{$client_id} //= rbac_get_manager_of_agency_clientid($rbac, $client_id);

    return $M{$client_id} || 0;
}

