#!/usr/bin/perl

=for none

бету из my_inc надо переключить на roprod

Основной код -- из DoCmdCurrencyConvert::cmd_massMoveToRealMoney

./lazuka.pl >lazuka.csv
Thu Mar 31 14:06:45 2016 start
Thu Mar 31 14:06:46 2016 before get_convert_type (1309 clients)
Thu Mar 31 14:06:58 2016 get_convert_type done
Thu Mar 31 14:06:58 2016 end

=cut

use strict;
use warnings;

use my_inc '/var/www/beta.lena-san.8083', for => 'protected';

use List::MoreUtils qw/any uniq firstval/;
use YAML;

use E;
use Client;
use User;
use Client::ConvertToRealMoney;
use GeoTools;

use utf8;
use open ":std" => ":utf8";

=for none

m pr:ppc:3 'select ClientID, uid from users where login = "lazuka"' -B
ClientID   uid
1845       13210880

=cut
my $agency_id = 1845;
my $agency_uid = 13210880;

run() unless caller();


sub run
{
    print STDERR localtime." start\n";
    my $clids_all = RBACDirect::rbac_get_subclients_clientids($rbac, $agency_uid);
    my $clid2currencies = mass_get_client_currencies($clids_all);
    $clids_all = [ grep { $clid2currencies->{$_}->{work_currency} eq 'YND_FIXED' } @$clids_all ];
    my $clients = get_all_sql(PPC(ClientID => $clids_all), ['
        SELECT ctfmt.ClientID
             , cfcc.country_region_id
             , cfcc.currency
        FROM clients_to_force_multicurrency_teaser ctfmt
        LEFT JOIN currency_convert_queue q ON ctfmt.ClientID = q.ClientID
        LEFT JOIN client_firm_country_currency cfcc ON ctfmt.ClientID = cfcc.ClientID
     ', WHERE => {
            'ctfmt.ClientID' => SHARD_IDS,
            'q.ClientID__is_null' => 1,
        }, '
        GROUP BY ctfmt.ClientID
        HAVING
                COUNT(DISTINCT cfcc.country_region_id) = 1
            AND COUNT(DISTINCT cfcc.currency) = 1
    ']);

    die unless @$clients;

    my %currency2client_count;
    my $clids = [ map { $_->{ClientID} } @$clients ];
    my $clid2nds = mass_get_client_NDS($clids, fetch_for_ynd_fixed_too => 1);
    my $clid2first_agency = Primitives::mass_get_client_first_agency($clids);
    my $clid2chief_uid = RBACElementary::rbac_get_chief_reps_of_clients($rbac, $clids);
    my $clients_data = mass_get_clients_data($clids, [qw/allow_create_scamp_by_subclient/]);

    print STDERR localtime." before get_convert_type (".(scalar @$clients)." clients)\n";
    # по факту, уже продублировали почти все проверки из Client::can_convert_to_real_money в SQL запросе выше, поэтому её не используем
    my %convert_type; 
    for my $client (@$clients) {
        my $client_id = $client->{ClientID};

        my $client_nds = $clid2nds->{$client_id};
        next unless defined $client_nds;

        my $is_free_client = $clients_data->{$client_id}->{allow_create_scamp_by_subclient};
        next if $is_free_client;

        my $currency = $client->{currency};
        my $country = $client->{country_region_id};

        $currency2client_count{$currency}++;

        # единственность стран и валют и то, что они такие -- проверили в исходном SQL-запросе
        my @country_currencies = ({region_id => $country, currency => $currency});
        my $convert_type = Client::ConvertToRealMoney::get_convert_type($client_id, $currency, $client_nds, \@country_currencies);
        $convert_type{$client_id} = $convert_type;
    }
    print STDERR localtime." get_convert_type done\n";

    #==========
    my $clid2uid_all = RBACElementary::rbac_get_chief_reps_of_clients($rbac, $clids_all);
    my $clients_all = get_all_sql(PPC(uid => [ values %$clid2uid_all ]), [
            'SELECT ClientID, login 
            FROM users', 
            WHERE => {
                'uid' => SHARD_IDS,
            }
        ]);
    my @fields = qw/login ClientID convert_type/;
    print join " ", @fields;
    print "\n";
    for my $cl (@$clients_all){
        $cl->{convert_type} = $convert_type{$cl->{ClientID}} || 'no_convert';
        print join " ", map {$cl->{$_}} @fields;
        print "\n";
    }
    print STDERR localtime." end\n";
}

