#!/usr/bin/env perl

use Direct::Modern;
use my_inc '.', for => 'protected';
use Yandex::DBTools;
use Yandex::DBShards;
BEGIN {
    $ENV{SETTINGS_LOCAL_SUFFIX} = 'ROProd';
};
use Settings;
use Excel::Writer::XLSX;

my $time_from = '2016-03-22';
my $time_to = '2016-04-01 23:59:59';

my $workbook = Excel::Writer::XLSX->new('first_aid_stat.xlsx');
my $worksheet = $workbook->add_worksheet();
$worksheet->write_row(0, 0, [
    'ClientID',
    'логин медиапланера',
    'статус',
    'дата принятия'
]);
$worksheet->set_column(0, 3, 20);
my $row_num = 1;

foreach my $shard (1 .. $Settings::SHARDS_NUM) {
    my $rows = get_all_sql(PPC(shard => $shard), [
        "select cu.clientid, u.login, status, accept_time
        from optimizing_campaign_requests ocr
        join users u on ocr.MediaUID = u.uid
        join campaigns c on ocr.cid = c.cid
        join users cu on c.uid = cu.uid",
        where => {
            create_time__between => [$time_from, $time_to],
            status => ['Accepted', 'AcceptDeclined', 'Rejected'],
        },
    ]);

    foreach my $row (@$rows) {
        $worksheet->write_row($row_num++, 0, [
            $row->{clientid},
            $row->{login},
            $row->{status},
            $row->{accept_time},
        ]);
    }
}

$workbook->close();
