#!/usr/bin/env perl

use Direct::Modern;
use my_inc '/var/www/ppc.yandex.ru/', for => 'protected';
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::HashUtils qw/hash_merge/;
BEGIN {
    $ENV{SETTINGS_LOCAL_SUFFIX} = 'ROProd';
};
use Settings;
use E;
use Excel::Writer::XLSX;

my $workbook = Excel::Writer::XLSX->new('top_client_video_part.xlsx');
my $worksheet = $workbook->add_worksheet();
$worksheet->write_row(0, 0, [
    'ClientID',
    'Clicks',
    'логин клиента',
    'название клиента',
    'фио менеджера клиента',
    'email менеджера клиента'
]);
$worksheet->set_column(0, 3, 20);
my $row_num = 1;

my @rows = map {s/[\r\n]//g; [split /\t/, $_]} grep {/\S/} <DATA>;
my @ids = map {$_->[0]} @rows;
my $clientid2uid = rbac_get_chief_reps_of_clients($rbac, \@ids);

my $uid2manageruids = rbac_get_managers_of_clients($rbac, [values %$clientid2uid]);
my @manageruids = map {$_->[0]} grep {@$_} values %$uid2manageruids;

my $uid2agency = rbac_mass_get_agencies_of_clients($rbac, [values %$clientid2uid]);
my @ag_uids = map { @$_ } values %$uid2agency;
my $ag_fio_email = get_hashes_hash_sql(PPC(uid => \@ag_uids), [
    "select uid, FIO, email from users",
    where => {
        uid => SHARD_IDS,
    }
]);

my $uid2fio_login = get_hashes_hash_sql(PPC(uid => [values %$clientid2uid]), ['select uid, FIO, login from users', WHERE => {uid => SHARD_IDS}]);
my $manageruid2fio_email = get_hashes_hash_sql(PPC(uid => \@manageruids), ['select uid, FIO, email from users', WHERE => {uid => SHARD_IDS}]);

foreach my $row (@rows) {
    my $uid = $clientid2uid->{$row->[0]};
    my $manager_info = {};
    if (@{$uid2agency->{$uid}}) {
        hash_merge $manager_info, $ag_fio_email->{$uid2agency->{$uid}->[0]};
    }
    elsif (@{$uid2manageruids->{$uid}}) {
        hash_merge $manager_info, $manageruid2fio_email->{$uid2manageruids->{$uid}->[0]};
    }
    $worksheet->write_row($row_num++, 0, [
        $row->[0],
        $row->[1],
        $uid2fio_login->{$uid}->{FIO},
        $uid2fio_login->{$uid}->{login},
        $manager_info->{FIO} // '',
        $manager_info->{email} // '',
    ]);
}

$workbook->close();

__DATA__
2419720	1250
15664	270
7878879	203
8045805	127
2202974	104
3649864	94
3648831	87
7321007	67
14816	66
8186670	56
8151831	19
8189716	15
7864426	6
8225150	2
8159688	1
8281341	1
7068397	1
8247536	450
7854986	81
2101876	54
7945200	48
8165278	40
1847577	30
8002750	27
7379779	26
1865928	26
471405	23
4088612	1523
5396730	963
7544145	909
2064599	700
8091687	490
4277023	327
8112014	259
7931248	226
7315928	222
8050654	201
8111961	184
7349169	174
8112042	80
7274149	39
7533920	20
7843613	14
8065151	9
8065217	7
7364752	4
8204132	2
7897964	1
912646	1
4535340	473
2403984	317
1177239	201
5459649	196
1782609	196
1096732	158
6820162	109
6811428	78
7932646	52
4734154	36
8039924	8
8040852	3
3068164	485
7053727	236
1857301	235
44418	221
7801798	110
3074230	110
7975717	80
5637878	78
6805910	73
7969963	55
7334010	49
7788314	46
1941608	42
1009427	28
7485668	27
7485413	16
7485629	16
7485643	13
2010444	13
8085924	12
3537256	12
7485658	11
7865448	2301
5702599	1213
6969491	1062
3211754	715
992161	676
5953063	655
1277549	616
5703169	495
1336288	396
7213815	383
7344223	255
2863638	27
8004320	20
1113019	10
3048114	2
7173201	1
4920794	4175
1984151	682
4920794	529
1640770	375
8191387	210
4507004	209
6435229	176
3344244	138
7050677	134
4319114	111
837811	111
5836255	68
1588555	43
2266582	36
7759484	29
44241	28
7720986	28
7300764	17
4699046	16
2416905	15
459056	14
2825230	13
2117301	4711
806354	3214
7865448	2301
2034704	2196
7889685	1242
7984763	1110
5448862	900
8161745	862
2387886	662
8208558	650
7106258	622
7984763	538
7382687	404
7697985	137
7487331	22
8208583	12
8338607	2
8148171	2
8105506	1
8045635	1
1518613	3818
2196715	229
7890926	187
7068029	171
5890598	151
6833458	111
7532500	94
7129979	94
2155095	51
7685132	36
5996088	32
7980930	30
7068035	23
7585881	23
7068044	11
6833510	9
7685137	6
7532484	4
948317	3351
806354	3214
7528105	2931
3130390	1031
503837	946
4495839	496
7532594	445
7899489	390
8225651	180
533830	174
8022157	33
2371019	33
7528105	2
2115531	2
6625531	7096
3995651	1101
4920794	529
7298350	253
951662	247
7964681	217
6540710	189
491007	178
8233639	148
7050677	134
389899	132
7948932	102
7480523	102
5718216	97
6873471	96
8027292	72
7933587	72
7906822	69
7381943	66
5968198	52
6962410	48
1588555	43
2117301	4711
4920794	4175
806354	3214
7865448	2301
2034704	2196
7889685	1242
7984763	1110
2733701	1068
5448862	900
8161745	862
2387886	662
7984763	538
1069393	501
7382687	404
7697985	137
7487331	22
7300764	17
8338607	2
8148171	2
8045635	1
6625531	7096
7071315	1262
8225651	180
3217715	126
479506	63
7966664	58
8195683	45
454072	44
7684113	33
950873	22
1542198	13
7221057	8
8123446	8
806354	3214
7865448	2301
7596069	1724
5702599	1213
2733701	1068
6969491	1062
8161745	862
3211754	715
992161	676
5953063	655
1277549	616
2733701	505
5703169	495
7382687	404
1336288	396
7213815	383
7794313	379
7697985	137
7732124	68
2863638	27
8004320	20
1113019	10
3048114	2
7173201	1
6625531	7096
7071315	1262
8225651	180
7460727	139
3217715	126
7904550	123
7966664	58
8195683	45
454072	44
7684113	33
950873	22
8089089	13
1542198	13
8205050	11
8141086	10
8123446	8
8139843	7
8205062	6
806354	3214
7528105	2931
7731149	1908
1881531	858
4225946	554
2047870	435
6747182	313
908556	298
403710	272
8067244	245
8025842	230
351724	226
5548887	210
1331170	159
7424973	56
3162040	39
6977269	30
412116	30
2209128	27
1146273	20
806354	3214
7865448	2301
7596069	1724
5702599	1213
2733701	1068
6969491	1062
8161745	862
3211754	715
992161	676
5953063	655
1277549	616
2733701	505
5703169	495
7382687	404
1336288	396
7213815	383
3595119	371
7697985	137
7732124	68
2863638	27
8004320	20
1113019	10
3048114	2
7173201	1
948317	3351
824619	602
1368297	581
3975942	555
2825418	475
4535340	473
4977973	395
466294	318
2831320	262
8240581	238
8235421	229
2918512	165
6949374	162
4766444	71
7809492	41
2371019	33
3187977	8
3287302	7
8125146	5
8043221	4
2115531	2
6951792	1
4027446	1
