#!/usr/bin/perl

use Direct::Modern;
use my_inc '/var/www/ppc.yandex.ru/', for => 'protected';
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::HashUtils qw/hash_merge/;
use Yandex::Blackbox 'bb_userinfo';
BEGIN {
    $ENV{SETTINGS_LOCAL_SUFFIX} = 'ROProd';
};
use Settings;
use Time::HiRes qw//;

my $rows = get_all_sql(PPC(shard => 'all'), "
    select u.uid, u.login
    from users u
    where exists (select 1 from campaigns c where c.uid = u.uid and statusActive = 1)
    limit 125
    offset 1000
    "
);

my $count = 0;
for my $row (@$rows) {
    my $uid = $row->{uid};
    my $info = bb_userinfo($uid, '127.0.0.1', "direct.yandex.ru", ['']);
    my $has_avatar = $info->{display_name}->{avatar}->{empty}->{content} ? 0 : 1;
    Time::HiRes::sleep(0.01);
    print STDERR "$row->{login}\t$has_avatar\n";
    $count += $has_avatar;
}
print "COUNT\t$count\n";


