#!/usr/bin/env perl

use Direct::Modern;
use my_inc '/var/www/ppc.yandex.ru/', for => 'protected';
# use my_inc '.', for => 'protected';
use Yandex::DBTools;
use Yandex::DBShards;
BEGIN {
    $ENV{SETTINGS_LOCAL_SUFFIX} = 'ROProd';
};
use Settings;
use E;
use Excel::Writer::XLSX;

use PrimitivesIds;
use Stat::StreamExtended;

# чтобы не гадать, что там происходит
use IO::Handle;
STDOUT->autoflush(1);

my $workbook = Excel::Writer::XLSX->new('agecy_clients_without_callouts.xlsx');
my $worksheet = $workbook->add_worksheet();
$worksheet->write_row(0, 0, [
    'логин клиента',
    'название агентства',
    'ФИО менеджера агентства',
    'email менеджера агентства',
    'открутки в у.е.',
]);
$worksheet->set_column(1, 3, 50);
$worksheet->set_column(0, 0, 30);
$worksheet->set_column(4, 4, 30);
my $row_num = 1;
my @records; # client_id, login, agency_client_id
my %agencies_managers; # agency_client_id => agency_manager_uid
my %uid2cids; # uid => [cid, ...]

foreach my $shard (1..$Settings::SHARDS_NUM) {
# foreach my $shard (2..2) {
    my $clientid_login_agency_clientid = get_all_sql(PPC_HEAVY(shard => $shard), ["
        select distinct users.clientid, users.uid, users.login, acr.agency_client_id from agency_client_relations acr
        left join users on (client_client_id = users.clientid)
        left join campaigns c on (users.uid = c.uid)
        left join phrases p on (p.cid = c.cid)
        left join banners b on (b.pid = p.pid)
        where
        c.statusActive = 'Yes'
        and c.type = 'text'
        and b.statusActive = 'Yes'
        and b.statusModerate = 'Yes'
        and b.statusShow = 'Yes'
        and not exists (select * from campaigns innerc
            left join phrases innerp on (innerp.cid = innerc.cid)
            left join banners innerb on (innerb.pid = innerp.pid)
            left join banners_additions ba on (innerb.bid = ba.bid)
            where ba.additions_type = 'callout'
            and innerc.uid = users.uid
        )
        "
    ]);
    foreach my $record (@$clientid_login_agency_clientid) {
        $agencies_managers{$record->{agency_client_id}} = undef;
    }
    push @records, @$clientid_login_agency_clientid;

    print "Unique users in shard $shard: " . scalar @$clientid_login_agency_clientid . "\n";

    # неоптимально, склонно к искажениям, но сойдёт — делаем тот же запрос с другими группировками
    my $uid_cids = get_all_sql(PPC_HEAVY(shard => $shard), ["
        select distinct c.cid, users.uid from agency_client_relations acr
        left join users on (client_client_id = users.clientid)
        left join campaigns c on (users.uid = c.uid)
        left join phrases p on (p.cid = c.cid)
        left join banners b on (b.pid = p.pid)
        where
        c.statusActive = 'Yes'
        and c.type = 'text'
        and b.statusActive = 'Yes'
        and b.statusModerate = 'Yes'
        and b.statusShow = 'Yes'
        "
    ]);
    foreach my $record (@$uid_cids) {
        push @{$uid2cids{$record->{uid}}}, $record->{cid};
    }

    print "shard processed\n";
}

my @agency_ids = keys %agencies_managers;
my %uid2login;
my %clientid2uid;

while (@agency_ids) {
    my @slice = splice @agency_ids, 0, 2200;
    my $agency_id2manager_uid = rbac_mass_get_manager_of_agencies_clientids($rbac, \@slice);
    my $agency_id2agency_uid = rbac_get_chief_reps_of_agencies($rbac, \@slice);

    foreach my $cl_id (keys %$agency_id2manager_uid) {
        $agencies_managers{$cl_id} = $agency_id2manager_uid->{$cl_id};
        $uid2login{$agency_id2manager_uid->{$cl_id}} = undef;
    }

    foreach my $cl_id (keys %$agency_id2agency_uid) {
        $clientid2uid{$cl_id} = $agency_id2agency_uid->{$cl_id};
        $uid2login{$agency_id2agency_uid->{$cl_id}} = undef;
    }
}

my $uid2fio_email = get_hashes_hash_sql(PPC(uid => [keys %uid2login]), ['select uid, FIO, email from users', WHERE => {uid => SHARD_IDS}]);

print scalar @records;

my $i = 0;
foreach my $row (@records) {
    my $sum = 'NULL';
    print "\n" unless ($i % 100);

    print $i . '-' x (100 - length sprintf("%u", $i)) . "\n" unless ($i % 1000);
    print '.';
    $i++;
    if (exists $uid2cids{$row->{uid}}) {
        my $order_ids = get_orderids(cid => $uid2cids{$row->{uid}});
        if (@$order_ids) {
            eval {
                my $stat = Stat::StreamExtended::get_stream_stat(order_ids => $order_ids,
                    filters => {sum => {gt => 0}},
                    group_by_date => 'month', currency => 'YND_FIXED',
                    date_from => "20160601", date_to => "20160610"
                );
                if (exists $stat->{totals} && exists $stat->{totals}->{sum}) {
                    $sum = $stat->{totals}->{sum};
                }
            };
        }
    }
    $worksheet->write_row($row_num++, 0, [
        $row->{login},
        $uid2fio_email->{$clientid2uid{$row->{agency_client_id}}}->{FIO},
        $uid2fio_email->{$agencies_managers{$row->{agency_client_id}}}->{FIO},
        $uid2fio_email->{$agencies_managers{$row->{agency_client_id}}}->{email},
        $sum,
    ]);
    # last if $i > 102;
}

$workbook->close();
