#!/usr/bin/env perl

use Direct::Modern;
use my_inc '/var/www/ppc.yandex.ru/', for => 'protected';
# use my_inc '.', for => 'protected';
use Yandex::DBTools;
use Yandex::DBShards;
BEGIN {
    $ENV{SETTINGS_LOCAL_SUFFIX} = 'ROProd';
};
use Settings;
use PrimitivesIds;

my $email = 'direct2505@mail.ru';

my %uids;
my %client_ids;

foreach my $shard (1..$Settings::SHARDS_NUM) {
# foreach my $shard (2..2) {
    my $uids = get_one_column_sql(PPC_HEAVY(shard => $shard), ["
        select uid from users_options
        where
        recommendations_email = '$email'
        union distinct
        select uid from users
        where
        email = '$email'
        union distinct
        select uid from users_api_options
        where
        api_developer_email = '$email'
        union distinct
        select uid from vcards
        where
        contact_email = '$email'
        "
    ]);
    foreach my $uid (@$uids) {
        $uids{$uid} = undef;
    }

    $uids = get_one_column_sql(PPC_HEAVY(shard => $shard), ["
        select uid from camp_options
        natural join campaigns
        where
        email = '$email'
        union distinct
        select uid from optimizing_campaign_requests
        left join campaigns using (cid)
        where
        email = '$email'
        "
    ]);
    foreach my $uid (@$uids) {
        $uids{$uid} = undef;
    }
    
    my $client_ids = get_one_column_sql(PPC_HEAVY(shard => $shard), ["
        select clientid from feeds
        where
        email = '$email'
        "
    ]);

    foreach my $client_id (@$client_ids) {
        $client_ids{$client_id} = undef;
    }
}

if (%uids) {
    my $client_ids = get_clientids(uid => [keys %uids]);
    foreach my $client_id (@$client_ids) {
        $client_ids{$client_id} = undef;
    }
}
local $, = "\n";
print keys %client_ids;
