#!/usr/bin/perl

use strict;
use warnings;

use utf8;
use open ':std', ':utf8'; 

=for none

бету переключить на конф. roprod

tail -n +2 clients|awk '{print $4}' |./script.pl

=cut

use my_inc '/var/www/beta.eboguslavskaya.9556', for => 'protected';

use YAML;

use Yandex::ListUtils;

use Yandex::DBTools;
use Settings; 
use Excel::Writer::XLSX;
use Getopt::Long;

my $output_file = 'res.xlsx';
GetOptions(
    'o|output-file=s' => \$output_file,
    ) || die "can't parse options, stop";

run() unless caller();

sub run
{
    die unless $Settings::CONFIGURATION eq 'roprod';

    my $workbook = Excel::Writer::XLSX->new($output_file);
    my $worksheet = $workbook->add_worksheet();
    $worksheet->write_row(0, 0, [
        'Логин',
        'Логин агентств',
        'Имена агентств',
        'Представители агентств',
        'Логины менеджеров агентсв',
        'ФИО менеджеров агентств',
        'Emails менеджеров агентств',
        'Логины прямых менеджеров',
        'ФИО прямых менеджеров',
        'Emails прямых менеджеров',
    ]);
    $worksheet->set_column(0, 3, 20);
    my $row_num = 1;

    while ( my $u = <> ){
        my $rep_uids = get_one_column_sql(PPC(uid => $u), "select rep.uid from users u join users rep on rep.ClientID = u.ClientID where u.uid = ?", $u);
        my $campaigns = get_all_sql(PPC(uid => $u), [
                'select cid, uid, ManagerUID, AgencyID, AgencyUID from campaigns',
                where => {
                    uid => $rep_uids, 
                    type => 'text',
                    archived => 'No',
                    statusEmpty => 'No',
                }
            ]
        );
        next unless @$campaigns;
        my @cids = map {$_->{cid}} @$campaigns;
        my $uid = $campaigns->[0]->{uid};
        my $login = get_one_field_sql(PPC(uid => $uid), "select login from users where uid = ?", $uid);
        my @AgencyIDs = map { $_->{AgencyID} || () } @$campaigns;
        my @AgencyUIDs = map { $_->{AgencyUID} || () } @$campaigns;
        my @ManagerUIDs = map { $_->{ManagerUID} || () } @$campaigns;
        my $agency_logins = get_one_column_sql(PPC(uid => \@AgencyUIDs), [
                'select login from users', 
                where => { uid => \@AgencyUIDs }]
        );
        my $agency_rep_logins = get_one_column_sql(PPC(ClientID => \@AgencyIDs), [
                "select login from users",
                where => { ClientID => \@AgencyIDs }]
        );
        $agency_rep_logins = xminus($agency_rep_logins, $agency_logins);
        my $agency_names = get_one_column_sql(PPC(ClientID => \@AgencyIDs), [
                'select distinct IFNULL(cl.name, u.fio) from users u join clients cl using(ClientID)', 
                where => {ClientID => \@AgencyIDs}
            ]
        );
        my $agency_manager_uids = get_one_column_sql(PPC(ClientID => \@AgencyIDs), [
                'select primary_manager_uid from clients',
                where => { ClientID => \@AgencyIDs }
            ]
        );
        my $managers = get_all_sql(PPC(uid => \@ManagerUIDs), [
                'select login, email, fio from users', 
                where => { uid => \@ManagerUIDs }]
        );
        my @manager_logins = map { $_->{login} || () } @$managers;
        my @manager_emails = map { $_->{email} || () } @$managers;
        my @manager_fios = map { $_->{fio} || () } @$managers;
        my $agency_managers = get_all_sql(PPC(uid => $agency_manager_uids), [
                'select login, email, fio from users', 
                where => { uid => $agency_manager_uids }]
        );
        my @agency_manager_logins = map { $_->{login} || () } @$agency_managers;
        my @agency_manager_emails = map { $_->{email} || () } @$agency_managers;
        my @agency_manager_fios = map { $_->{fio} || () } @$agency_managers;


        $worksheet->write_row($row_num++, 0, [
            $login, 
            join(",", @{$agency_logins||[]}), 
            join(",", @{$agency_names||[]}), 
            join(",", @{$agency_rep_logins||[]}), 
            join(',', @agency_manager_logins),
            join(',', @agency_manager_fios),
            join(',', @agency_manager_emails),
            join(',', @manager_logins),
            join(',', @manager_fios),
            join(',', @manager_emails),
        ]);
    }
    $workbook->close();
}
