#!/usr/bin/perl

use Direct::Modern;
use open ':std', ':utf8';

=for none

    бету переключить на конф. roprod

    https://st.yandex-team.ru/DIRECT-56124

    ./affected-uids.sh # создаст uids.txt
    ./malfunctioned-apps.sh # создаст apps.txt
    ./apps.pl < apps.txt > apps.tsv

=cut

use JSON;

use my_inc '/var/www/beta.hmepas.9178', for => 'protected';

use YAML;

use Yandex::OAuth;
use Yandex::DBTools;
use Yandex::DBShards;
use Settings;


die unless $Settings::CONFIGURATION eq 'roprod';

run() unless caller();

sub fill_owners {
    my $apps = shift;
    my $apps_info = get_hashes_hash_sql(PPCDICT, [ "select application_id, name, uid, request_info from api_app_certification_request", where => {application_id => [keys %$apps], status => 'Approve', access_type => 'normal'} ]);
    my $users_data = users_data([ map { $_->{uid} } values %$apps_info ]);

    my @fill_oauth; # не зарегистировано, узанаем у oauth что ему известно
    foreach my $app_id (keys %$apps) {
        $apps->{$app_id}->{developer_email} = '-';
        if(my $info = $apps_info->{$app_id}) {
            $apps->{$app_id}->{name} = $info->{name};
            $apps->{$app_id}->{developer_email} = from_json($info->{request_info})->{developer_email};
            $apps->{$app_id}->{info} = $users_data->{ $info->{uid} }||{ err => "user uid:$info->{uid} not found" };
        } else {
            push @fill_oauth, $app_id;
        }
    }

    foreach my $app_id (@fill_oauth) {
        my $app_info = get_oauth_info($app_id) or die "no app info for $app_id";
        $apps->{$app_id}->{name} = delete $app_info->{name};
        $apps->{$app_id}->{info} = $app_info||{ err => 'no data in oauth' };
    }
}

sub get_oauth_info {
    my $app_id = shift;
    my $info = Yandex::OAuth::oa_get_app_info($app_id);
    return {
        name => $info->{name},
        callback => $info->{callback},
        homepage => $info->{homepage},
        localized_scope => $info->{localized_scope},
        created => "".localtime( $info->{ctime} )
    };
}

sub fill_clients {
    my $apps = shift;
    my $uids = [ map { @{$_->{users}} } values %$apps ];
    my $uid2client_data = users_data($uids);
    foreach my $app_id (keys %$apps) {
        $apps->{$app_id}->{users} = [ map { $uid2client_data->{$_} } @{$apps->{$app_id}{users}} ];
    }
}

sub users_data {
    my $uids = shift;
    return get_hashes_hash_sql(PPC(uid => $uids), [ "select uid, login, cl.ClientID, email, cl.name, fio, phone from users u join clients cl using(clientid)", where => {uid => SHARD_IDS}]);
}

sub app_cmp {
    my ($l, $r) = @_;
    return $l->{errors} <=> $r->{errors};
}

sub run {
    say join "\t", qw/app_id err_cnt name login email developer_email app_info users/;

    my $uid2cnt;
    my @uids;
    my $apps = {};

    while(<>) {
        my (undef, $err_cnt, $app, $uid) = split /\s+/;
        push @{$apps->{$app}->{users}}, $uid;
        $apps->{$app}->{errors} += $err_cnt;
    }

    fill_clients($apps);
    fill_owners($apps);

    foreach my $app_id (sort { app_cmp($apps->{$b}, $apps->{$a}) } keys %$apps) {
        my $app = $apps->{$app_id};
        my $login = '-';
        my $email = '-';
        if ($app->{info}{email}) {
            $email = $app->{info}{email};
            $login = $app->{info}{login};
        }
        say qq~$app_id\t$app->{errors}\t$app->{name}\t$login\t$email\t$app->{developer_email}~
            . "\t" . to_json($app->{info})
            . "\t" . to_json($app->{users}||[]);
    }
}

