#!/usr/bin/perl

use Direct::Modern;
use open ':std', ':utf8';

=for none

    бету переключить на конф. roprod

    https://st.yandex-team.ru/DIRECT-56124

    ./apps_logins.sh # создаст apps_logins.txt
    ./apps_logins.pl < apps_logins.txt > apps_logins.tsv

=cut

use JSON;
use List::MoreUtils qw/uniq/;

use my_inc '/var/www/beta.hmepas.10917', for => 'protected';

use YAML;

use Yandex::ListUtils;

use Yandex::DBTools;
use Yandex::DBShards;
use Settings;
use PrimitivesIds;
use RBAC2::Extended;
use RBACDirect;
use RBACElementary;
use Yandex::OAuth;

my $rbac = RBAC2::Extended->get_singleton(0);

die unless $Settings::CONFIGURATION eq 'roprod';

run() unless caller();

sub fill_logins {
    my ($results, $uids) = @_;

    my $uid2login = get_hashes_hash_sql(PPC(uid => $uids), [ "select uid, login, email, fio, phone from users", where => {uid => SHARD_IDS}]);

    foreach my $r (@$results) {
        $r->{login} = $uid2login->{$r->{uid}}{login};
    }
}

sub fill_apps_info {
    my ($results, $app_ids) = @_;
    
    my $apps_info = get_hashes_hash_sql(PPCDICT, [ "select application_id, name, uid, request_info from api_app_certification_request", where => {application_id => $app_ids, status => 'Approve', access_type => 'normal'} ]);

    foreach my $app_id (@$app_ids) {
        next if exists $apps_info->{$app_id};
        $apps_info->{$app_id} = get_oauth_info($app_id);
    }

    foreach my $r (@$results) {
        my $app_id = $r->{app_id};
        $r->{application_name} = $apps_info->{$app_id}->{name} || 'fuk';
    }
}

sub get_oauth_info {
    my $app_id = shift;
    my $info = Yandex::OAuth::oa_get_app_info($app_id);
    return {
        name => $info->{name},
        callback => $info->{callback},
        homepage => $info->{homepage},
        localized_scope => $info->{localized_scope},
        created => "".localtime( $info->{ctime} )
    };
}

sub run {
    say join "\t", qw/operator_login application_id application_name errors/;

    my $apps;
    my $uids;
    my $results = [];

    while(<>) {
        my (undef, $err_cnt, $uid, $app_id) = split /\s+/;
        $apps->{$app_id} = undef;
        $uids->{$uid} = undef;
        push $results, {
            app_id => $app_id,
            uid => $uid,
            errors => $err_cnt,
        };
    }

    fill_logins($results, [ keys %$uids ]);
    fill_apps_info($results, [ keys %$apps ]);

    foreach my $r (@$results) {
        say qq~$r->{login}\t$r->{app_id}\t$r->{application_name}\t$r->{errors}~;
    }
}

