#!/usr/bin/perl

# usage:
# zcat /mnt/remote-log-rfs/ppcback01*/protected/201608/ordersNotExceededBudget.log.2016082[2-8]* | ./stat.pl

use Direct::Modern;
use JSON;

my @problem_codes = (1 .. 6);

my $order_id;
my @hour_stat;
my @camp_stat;


while (my $line = readline) {
    chomp $line;
    my ($date, $time, $data) = split "\t" => $line;

    if ($data =~ /^\d+$/) {
        $order_id = $data;
        next;
    }

    if ($data =~ /^\{/) {
        my $alert = decode_json $data;
        my ($hour) = $time =~ /^(\d+):/;
        my $problems = $alert->{problems} or next;

        my $problem_str = join "," => grep {$problems & (1 << $_)} @problem_codes;
        next if !$problem_str;
        say join "\t" => ($date, $time, $order_id, $problem_str);
        next;

        for my $problem (@problem_codes) {
            next unless $problems & (1 << $problem);
            $hour_stat[$problem]->[$hour]++;
            $camp_stat[$problem]->{$order_id}++;
        }

#        last  if our $cnt++ > 100000;
        next;
    }
}
exit;

for my $hour (0 .. 23) {
    say join "\t" => "$hour:", map {$hour_stat[$_]->[$hour] || 0} @problem_codes;
}

for my $problem (@problem_codes) {
    my $stat = $camp_stat[$problem];
    my @camps = sort {$stat->{$b} <=> $stat->{$a}} keys %$stat;
    say "$problem:  " . join "," => map {$camps[$_] || ()} (0 .. 5);
}


