#!/usr/bin/perl

use Direct::Modern;

use DDP;

use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Log;
use Yandex::Validate;

$Yandex::Log::LOG_ROOT = '/home/ppalex/logs/';

use my_inc q!/home/ppalex/trunk!, for => 'protected';

use Client;
use RBAC2::Extended;
use RBACDirect;
use RBACElementary;
INIT { $Settings::LOCK_ROOT = '/home/ppalex/tmp'; }
use ScriptHelper;
use Settings;
use ShardingTools;
use User;

$Yandex::DBTools::QUERIES_LOG = undef;
$ScriptHelper::is_beta = 1;

use open ':std' => ':utf8';

$log->out('START');

my $rbac = RBAC2::Extended->get_singleton( 1 ) or $log->die("can't get rbac");

my %RESULT;
for my $shard (ppc_shards()) {
    $log->out("fetch agencies with YND_FIXED clients in #$shard shard");
    my $data = get_hash_sql(PPC(shard => $shard), [
                                'SELECT acr.agency_client_id',
                                     ', MAX(cl.create_date) AS last_client_created_at',
                                'FROM agency_client_relations AS acr',
                                'LEFT JOIN clients AS cl ON acr.client_client_id = cl.ClientID',
                                'LEFT JOIN users AS u ON u.ClientID = acr.client_client_id',
                                'WHERE IFNULL(cl.work_currency, "YND_FIXED") = "YND_FIXED"',
                                      'AND acr.client_archived = "No"',
                                      'AND acr.bind = "Yes"',
                                'GROUP BY acr.agency_client_id',
                                # 'LIMIT 10',
                            ]);
    for my $ag_clid (keys %$data) {
        my $last = $data->{$ag_clid} // '--';
        if (!exists $RESULT{$ag_clid} || $RESULT{$ag_clid} le $last) {
            $RESULT{$ag_clid} = $last;
        }
    }
}

my %uids;

$log->out("fetch agency uids");
my $ag2uids = rbac_get_agency_uids_by_clientids($rbac, [keys %RESULT]);
$uids{$_} = undef for xflatten values %$ag2uids;

$log->out("fetch agency chiefs");
my $ag2chiefs = rbac_get_chief_reps_of_agencies($rbac, [keys %RESULT]);
$uids{$_} = undef for xflatten values %$ag2chiefs;


$log->out("fetch agency managers");
my $ag2man = rbac_mass_get_manager_of_agencies_clientids($rbac, [keys %RESULT]);
$uids{$_} = undef for grep {$_} values %$ag2man;

$log->out("fetch users data");
my $uinfo = get_users_data([keys %uids], [qw/login email fio lang/]);

$log->out("fetch clients data");
my $cinfo = mass_get_clients_data([keys %RESULT], [qw/name non_resident/]);

my @sorted = sort { $RESULT{$b} cmp $RESULT{$a} } keys %RESULT;
$log->out("print result");

print join("\t", qw/agency_client_id agency_chief_login last_client_created_at agency_name agency_email agency_lang agency_non_resident primary_manager_login primary_manager_email agency_logins/), "\n";
for my $id (@sorted) {
    my $login;
    if (exists $ag2chiefs->{$id} && exists $uinfo->{ $ag2chiefs->{$id} }) {
        $login = $uinfo->{ $ag2chiefs->{$id} }->{login};
    }
    next unless $login;

    print join("\t",
               $id,
               $login,
               $RESULT{$id},
               $cinfo->{$id}->{name} || $uinfo->{ $ag2chiefs->{$id} }->{fio} || '--',
               $uinfo->{ $ag2chiefs->{$id} }->{email} || '--',
               $uinfo->{ $ag2chiefs->{$id} }->{lang} || 'ru',
               $cinfo->{$id}->{non_resident} // '?', 
               $uinfo->{ $ag2man->{$id} }->{login} || '--',
               $uinfo->{ $ag2man->{$id} }->{email} || '--',
               join(",", sort map { $uinfo->{$_}->{login} } @{ $ag2uids->{$id} } ),
               ), "\n";
}

$log->out('FINISH');
