#!/usr/bin/perl

use Direct::Modern;
use open ':std', ':utf8';

=for none

    бету переключить на конф. roprod

    https://st.yandex-team.ru/DIRECT-58523

    apps_req_cnt.sh > apps.txt
    ./apps.pl < apps.txt > apps_stat.tsv

=cut

use JSON;

use my_inc '/var/www/beta.hmepas.10911', for => 'protected';

use YAML;

use Yandex::OAuth;
use Yandex::DBTools;
use Yandex::DBShards;
use Settings;

use User qw/get_user_data/;

die unless $Settings::CONFIGURATION eq 'roprod';

my @USER_FLDS = qw/api_developer_email email login/;
run() unless caller();

sub fill_owners {
    my $apps = shift;
    my $apps_info = get_hashes_hash_sql(PPCDICT, [ "select application_id, name, uid, request_info from api_app_certification_request", where => {application_id => [keys %$apps], status => 'Approve', access_type => 'normal'} ]);

    my @fill_oauth; # не зарегистировано, узанаем у oauth что ему известно
    foreach my $app_id (keys %$apps) {
        my $app = $apps->{$app_id};
        if(my $info = $apps_info->{$app_id}) {
            $app->{application_name} = $info->{name};
            $app->{request_email} = from_json($info->{request_info})->{developer_email};
            $app->{owner} = get_user_data($info->{uid}, \@USER_FLDS);
            $app->{owner}{$_} //= '' foreach @USER_FLDS;
        } else {
            $apps->{$app_id}->{request_email} = '';
            push @fill_oauth, $app_id;
        }
    }

    foreach my $app_id (@fill_oauth) {
        my $app_info = get_oauth_info($app_id) or die "no app info for $app_id";
        my $app = $apps->{$app_id};
        $app->{application_name} = $app_info->{application_name};
        $app->{owner}{$_} = '' foreach @USER_FLDS;
    }
}

sub get_oauth_info {
    my $app_id = shift;
    my $info = Yandex::OAuth::oa_get_app_info($app_id);

    return {
        application_name => $info->{name}
    };
}

sub app_cmp {
    my ($l, $r) = @_;
    return $l->{errors} <=> $r->{errors};
}

sub run {
    say join "\t", qw/errors app_id app_name request_email login email api_developer_email/;
    #кол-во; application_id; название приложения; email из заявки; логин который заполнял заявку; email этого логина; email контактного лица из настроек api этого логина

    my $apps = {};

    while(<>) {
        my (undef, $err_cnt, $app) = split /\s+/;
        $apps->{$app}->{errors} += $err_cnt;
    }

    fill_owners($apps);

    foreach my $app_id (sort { app_cmp($apps->{$b}, $apps->{$a}) } keys %$apps) {
        my $app = $apps->{$app_id};
        my $owner = $apps->{$app_id}{owner};
        say join("\t", $app->{errors}, $app_id, $app->{application_name}, $app->{request_email}, $owner->{login}, $owner->{email}, ($owner->{api_developer_email}||'-'));
    }
}

