#!/usr/bin/perl

use Direct::Modern;
use open ':std', ':utf8';

=for none

    бету переключить на конф. roprod

    https://st.yandex-team.ru/DIRECT-58523

    ./affected-users.sh
    ./affected-users-apps.sh
    ./users.pl > users.tsv

=cut

use JSON;
use List::MoreUtils qw/uniq/;

use my_inc '/var/www/beta.hmepas.10911', for => 'protected';

use YAML;

use Yandex::ListUtils;

use Yandex::DBTools;
use Yandex::DBShards;
use Settings;
use PrimitivesIds;
use RBAC2::Extended;
use RBACDirect;
use RBACElementary;

my $rbac = RBAC2::Extended->get_singleton(0);

die unless $Settings::CONFIGURATION eq 'roprod';

run() unless caller();

sub aggregate_by_client {
    my $users = shift;
    my $uids = [keys %$users];

    my $uid2client = get_hashes_hash_sql(PPC(uid => $uids), [
        "select u.uid, u.login, cl.ClientID, cl.name, u.email from users u join clients cl on u.clientid = cl.clientid", where => { uid => SHARD_IDS }
    ]);

    my $clients = {};
    foreach my $uid (@$uids) {
        my $cl = $uid2client->{$uid} or next;

        foreach my $f (qw/uid login email/) {
            $users->{$uid}->{$f} = $cl->{$f};
            delete $cl->{$f};
        }

        $users->{$uid}{client} = $cl;

        $clients->{$cl->{ClientID}} //= $cl;
        push @{$cl->{affected_uids}}, $uid;
    }

    return $clients;
}

sub fill_chief_reps {
    my $clients = shift;
    my $clid2uid = RBACElementary::rbac_get_chief_reps_of_clients($rbac, [ keys %$clients ]);
    foreach my $id (keys %$clients) {
        $clients->{$id}{chief_rep_uid} = $clid2uid->{$id} // $clients->{$id}{affected_uids}[0];
        use Data::Dumper; $Data::Dumper::Deparse = 1; die "no chief rep for " . Dumper $clients->{$id} unless $clients->{$id}{chief_rep_uid};
    }
}

sub fill_reps {
    my $clients = shift;
    my $reps = get_hashes_hash_sql(PPC(ClientID => [ keys %$clients ]), ["select uid, login, email, phone, ClientID from users u ", where => { 'ClientID' => SHARD_IDS } ]);

    foreach my $uid (keys %$reps) {
        my $rep = $reps->{$uid};
        my $clientid = $rep->{ClientID};
        push @{$clients->{$clientid}{reps}}, {
            uid => $rep->{uid},
            login => $rep->{login},
            email => $rep->{email},
            phone => $rep->{phone}
        };
    }

    foreach my $cl (values %$clients) {
        $cl->{chief_rep} = $reps->{delete $cl->{chief_rep_uid}}//{};
        foreach my $affected_uid (@{$cl->{affected_uids}}) {
            die "no rep for $affected_uid" unless exists $reps->{$affected_uid};
            push @{$cl->{affected}}, $reps->{$affected_uid};
        }
    }

    return;
}

sub fill_agency_and_managers {
    my $clients = shift;
    my ($rep2clientid, $reps);
    foreach my $clientid (keys %$clients) {
        foreach my $rep (@{$clients->{$clientid}{reps}}) {
            my $uid = $rep->{uid};
            $rep2clientid->{$uid} = $clientid;
            push @$reps, $uid;
        }
    }

    my $is_agency = get_hash_sql(PPC(uid => $reps), ["select DISTINCT AgencyID, 1 from campaigns", where => {AgencyUID => SHARD_IDS}]); # по AgencyID нет индекса

    foreach my $clientid (keys %$clients) {
        $clients->{$clientid}{is_agency} = $is_agency->{$clientid}||0;
    }

    my $manager_uids;

    my $agencies = [ grep { $_->{is_agency} } values %$clients ];
    my ($agency_ids, $agency_reps_uids);
    foreach my $a (values %$clients) {
        push @$agency_ids, $a->{ClientID};
        push @$agency_reps_uids, map { $_->{uid} } @{$a->{reps}};
    }

    # Главные мененджеры агентств
    my $agency_managers = get_hash_sql(PPC(ClientID => $agency_ids), [
            'select ClientID, primary_manager_uid from clients',
            where => { ClientID => SHARD_IDS }
        ]
    );
    foreach my $clientid (keys %$agency_managers) {
        if (my $uid = $agency_managers->{$clientid}) {
            push @{$clients->{$clientid}{managers}}, $uid;
            push @$manager_uids, $uid;
        }
    }
    # Менеджеры кампаний под агентствами
    my $agency_manager_uid2clientid = get_hash_sql(PPC(uid => $agency_reps_uids), ["select DISTINCT ManagerUID, AgencyID from campaigns", where => {AgencyUID => SHARD_IDS, ManagerUID__is_not_null => 1 }]);
    foreach my $manager_uid (keys %$agency_manager_uid2clientid) {
        my $clientid = $agency_manager_uid2clientid->{$manager_uid};
        push @{$clients->{$clientid}->{managers}}, $manager_uid;
    }

    # и всего что выше конечно же не достаточно, поэтому сходим еще и в РБАК, но дабы не угробить онный сходим только для агентств, для которых все еще не нашлось менеджеров
    my $no_man_reps;
    foreach my $ag (@$agencies) {
        next if @{$ag->{managers} || []};
        push @$no_man_reps, map { $_->{uid} } @{$ag->{reps}};
    }
    my $agency_uid2manager_uid = { map { $_ => RBACDirect::rbac_get_manager_of_agency($rbac, $_, 'text') } uniq @$no_man_reps};
    foreach my $agency_uid (keys %$agency_uid2manager_uid) {
        my $ag_id = $rep2clientid->{$agency_uid};
        push @{$clients->{$ag_id}{managers}}, $agency_uid2manager_uid->{$agency_uid};
    }

    # Мененджеры самоходных кампаний
    my @direct_clients = grep { !$_->{is_agency} } values %$clients; # самоходные клиенты
    my $direct_reps;
    foreach my $cl (@direct_clients) {
        push @$direct_reps, map { $_->{uid} } @{$cl->{reps}};
    }
    my $manager_uid2clientid = get_hash_sql(PPC(uid => $direct_reps), ["select DISTINCT ManagerUID, ClientID from campaigns join users using(uid)", where => {uid => SHARD_IDS, ManagerUID__is_not_null => 1 }]);
    foreach my $manager_uid (keys %$manager_uid2clientid) {
        my $clientid = $manager_uid2clientid->{$manager_uid};
        push @{$clients->{$clientid}->{managers}}, $manager_uid;
        push @$manager_uids, $manager_uid;
    }

    # заполняем данные и тех и других
    my $managers_contacts = get_hashes_hash_sql(PPC(uid => $manager_uids), ["SELECT uid, login, fio , email, phone from users", where => {uid => SHARD_IDS}]);
    foreach my $cl (values %$clients) {
        $cl->{managers} = [
            map { $managers_contacts->{$_} } @{$cl->{managers}}
        ];
    }


    return;
}

sub u2emails_list {
    my $users = shift;
    return join(', ', uniq grep { $_ } map { $_->{email} } @$users);
}

sub users_errors {
    my $users;
    open(my $users_fh, "./users.txt") or die "$!";
    while(<$users_fh>) {
        my (undef, $err_cnt, $uid) = split /\s+/;
        $users->{$uid}{errors} = $err_cnt;
    }
    my $logins = get_uid2login(uid => [ keys %$users ]);
    foreach my $uid (keys %$users) {
        $users->{$uid}{login} = $logins->{$uid};
    }
    return $users;
}

sub fill_apps {
    my $users = shift;
    open(my $apps_stat_fh, "./uid-app.txt") or die "$!";
    while(<$apps_stat_fh>) {
        my (undef, $err_cnt, $uid, $app_id) = split /\s+/;
        push @{$users->{$uid}{app_ids} //= []}, $app_id;
    }
    return;
}

sub run {
    say join "\t", qw/err_cnt login email ClientID chief_login chief_email is_agency manager_emails apps/;

    my $users = users_errors();

    fill_apps($users);

    my $clients = aggregate_by_client($users);
    fill_chief_reps($clients);
    fill_reps($clients);
    fill_agency_and_managers($clients);

    foreach my $uid (sort { $users->{$b}{errors} <=> $users->{$a}{errors} } keys %$users) {
        my $u = $users->{$uid};
        my $client_id = $u->{client}{ClientID};

        print join("\t", $u->{errors}, ($u->{login}//''), ($u->{email}//''), ($client_id//'0'));

        if($client_id) {
            my $c = $clients->{$client_id};
            print "\t" . join("\t",
                $c->{chief_rep}->{login},
                $c->{chief_rep}->{email},
                $c->{is_agency},
                u2emails_list($c->{managers}),
                join(', ', @{$u->{app_ids}//[]})) if $c;
        }
        print "\n";
    }
}


