#!/usr/bin/perl

use Direct::Modern;

use JSON;

my %stat_all;
my %stat_act;

while (my $line = <>) {
    chomp $line;
    my $camp = eval { from_json $line };
    last if !$camp;

    _add(\%stat_all, $camp);
    _add(\%stat_act, $camp)  if $camp->{is_active};
}

delete $stat_all{uid};
say 'All: ' . to_json(\%stat_all, {canonical => 1, pretty => 1});
delete $stat_act{uid};
say 'Active: ' . to_json(\%stat_act, {canonical => 1, pretty => 1});



sub _add {
    my ($stat, $camp) = @_;
    $stat->{total}++;
    my $langs = join ',' => sort keys %{$camp->{lang}};
    $stat->{lang}->{$langs}++;
    $stat->{clients}++  if !$stat->{uid}->{$camp->{uid}};
    $stat->{uid}->{$camp->{uid}}++;
    return;
}
