#!/usr/bin/perl

use common::sense;
use lib '/var/www/ppc.yandex.ru/';
use my_inc '/var/www/ppc.yandex.ru', for => 'protected';
BEGIN { $ENV{SETTINGS_LOCAL_SUFFIX} = 'ROProd'; }
use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Clickhouse;
use Yandex::ListUtils qw/xflatten/;

use RBAC2::Extended;
use RBACDirect;
use RBACElementary;

my $rbac = RBAC2::Extended->get_singleton( 1 ) or die("can't get rbac");

my $clh = Yandex::Clickhouse->new(
    host => 'ppchouse01i',
    user => 'readonly',
);

my $query = qq{
SELECT DISTINCT uid
FROM ppclog_cmd 
WHERE (
    log_date > (today() - 20))
    AND visitParamHas(param, 'save_draft')
    AND (visitParamExtractInt(param, 'save_draft') = 1)
    AND (cmd = 'bannersMultiSave')
    AND (role = 'agency')
LIMIT 200
};

my @ag_uids = xflatten @{$clh->query($query)->tsv};
my $ag_info = get_hashes_hash_sql(PPC(uid => \@ag_uids), [
    "select uid, login, fio from users",
    where => { uid => SHARD_IDS }
]);
my %managers = map { ($_ => rbac_get_manager_of_agency($rbac, $_)) } @ag_uids;
my $logins = get_hashes_hash_sql(PPC(uid => [values %managers]), ["select uid, login, fio from users",
    where => { uid => SHARD_IDS },
]);

while (my ($muid, $mauid) = each %managers) {
    my $mlogin = $logins->{$mauid}->{login};
    my $mfio = $logins->{$mauid}->{fio};
    my $ag = $ag_info->{$muid};
    print "$muid $ag->{login} $ag->{fio} $mauid $mlogin $mfio\n";
}
