#!/usr/bin/perl

use Direct::Modern;
use my_inc "../..";

use Settings;
use ScriptHelper;

use Yandex::Clickhouse;

=head1 DESCRIPTION

    Cкрипт считает и пишет в лог количество ошибок 'Broken pipe' от BannerLand по дням за заданный дипазон

    Параметры:
    --from YYYY-MM-DD
        начиная с какой даты смотреть логи
    --to YYYY-MM-DD
        по какую дату смотреть лог
    --host - (опционально) хост кликхауса, где лежат логи

    LOG_TEE=1 perl protected/one-shot/DIRECT-64270-count_broken_pipe.pl --from 2016-10-01 --to 2016-11-01

=cut

extract_script_params(
    'from=s' => \my $date_from,
    'to=s' => \my $date_to,
    'host' => \my $host,
);

my $clh = Yandex::Clickhouse->new(
    host => defined $host ? $host : 'ppchouse02k.yandex.ru',
    user => 'readonly',
);
$clh->query_format('TabSeparatedWithNames');

my $logs = $clh->query(
    "select log_date, count() as errors
    from messages
    where
        log_date >= toDate('$date_from')
    and log_date <= toDate('$date_to')
    and method = 'ppcFeedToBannerLand.transport'
    and like(message, '%Broken pipe%')
    group by log_date
")->tsv(names => 1);

$log->out("log_date\terrors");
for my $row (@$logs) {
    $log->out("$row->{log_date}\t$row->{errors}")
}
