#!/usr/bin/perl

BEGIN { $ENV{SETTINGS_LOCAL_SUFFIX} = 'ROProd'; }
use Direct::Modern;
use my_inc '/var/www/ppc.yandex.ru', for => 'protected';
use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use MetrikaCounters;
use List::MoreUtils qw/uniq/;

my $counter = 8973832;

my @logins = qw/
app-ru-6519
Flight-RMKT-RU-6523 
Flight-Search-BY-6510
Flight-Search-CIS-6510 
Flight-Search-KZ-6510
Flight-Search-LED-6510 
Flight-Search-MOW-6510 
Flight-Search-ROW-6510 
Flight-Search-RU-6510
Flight-Search-TR-6510
Flight-Search-UA-6510
Flight-Text-Display-RU-6521 
Hotel-Search-RU-6510
/;

my $login2uid = get_hash_sql(PPC(login => \@logins), ["select login,uid from users", where => { login => \@logins } ]);

for my $login (@logins) {
    unless ($login2uid->{$login}) {
        die "missing uid for $login";
    }
}
my @uids = values %$login2uid;

my @goals = map { $_->goal_id } @{MetrikaCounters::download_counter_goals([8973832])->{8973832}};

my $camp_goal_ids = get_one_column_sql(PPC(uid => \@uids), [
    "select distinct autobudget_goal_id from campaigns", where => {
        uid => SHARD_IDS,
        autobudget_goal_id => \@goals,
    }
]);

my $bm_goals = get_one_column_sql(PPC(uid => \@uids), [
    "select distinct broad_match_goal_id from camp_options co join campaigns c using(cid)", where => {
        uid => SHARD_IDS,
        broad_match_goal_id => \@goals
    }
]);

my $camp_metrika_goals = get_one_column_sql(PPC(uid => \@uids), [
    "select distinct goal_id from camp_metrika_goals cmg join campaigns c using(cid)", where => {
        uid => SHARD_IDS,
        goal_id => \@goals,
    }
]);

my $ret_goals = get_one_column_sql(PPC(uid => \@uids), [
    "select distinct goal_id from retargeting_goals rg join bids_retargeting br using(ret_cond_id) join phrases p using(pid)
        join campaigns c using(cid)",
    where => {
        uid => SHARD_IDS,
        goal_id => \@goals,
    }
]);

my @all_goals = uniq(@$camp_goal_ids, @$bm_goals, @$camp_metrika_goals, @$ret_goals);
print ''.(join "\n", @all_goals)."\n";

