#!/usr/bin/perl

use common::sense;
use lib '/var/www/ppc.yandex.ru/';
use my_inc '/var/www/ppc.yandex.ru', for => 'protected';
BEGIN { $ENV{SETTINGS_LOCAL_SUFFIX} = 'ROProd'; }
use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::YT::TableReader;
use Yandex::Clickhouse;
use Yandex::ListUtils qw/xflatten/;
use Carp;
use DBStat;
use PrimitivesIds qw/get_orderids get_orderid2clientid/;
use List::Util qw/sum/;
use List::MoreUtils qw/uniq/;
use JSON;

$SIG{__DIE__} = \&Carp::confess;


my @cids = @{get_cids_from_clh()};
#my @cids = @{get_cids_from_yt()};
printf STDERR "done, got %d cids\n", scalar @cids;

my $oids = get_orderids(cid => \@cids);
my $stat = DBStat->get_orders_stat_date_fetch_bs([map { {OrderID => $_} } @$oids], '2017-06-01', '2017-06-30', single_currency => 1, by_target => 1);

# print to_json($stat, { pretty => 1 });

my $sum = 0;
my @oids_with_ctx_shows;
for my $oid (@$oids) {
    my $osum += sum map { $_->{Cost_1} } values %{$stat->{$oid}};
    if ($osum) {
        $sum += $osum;
        push @oids_with_ctx_shows, $oid;
        #print "$oid\t$osum\n";
    }
}

my $oid2clid = get_orderid2clientid(OrderID => \@oids_with_ctx_shows);
my @clients = uniq values %$oid2clid;


print "\nTotal: $sum rub, ".scalar(@oids_with_ctx_shows)." camps, ".scalar(@clients)." clients\n";

sub get_cids_from_clh {
    my $clh = Yandex::Clickhouse->new(
        host => 'ppchouse01i',
        user => 'readonly',
        timeout => 7200,
    );

    my $query = qq{
    SELECT DISTINCT cid
    FROM bsexport_data
    WHERE
        log_date >= toDate('2017-06-01') and log_date <= toDate('2017-06-30')
        and data like '%statusNoBehav%'
        and visitParamExtractInt(data, 'statusNoBehav') = 1
    };

    print STDERR "begin clh query... ";
    my @cids = xflatten @{$clh->query($query)->tsv};

    return \@cids;
}

sub get_cids_from_yt {
    # таблица с cid кампаний, у которых по состоянию на 2017-07-01 был отключен поведенческий таргетинг и в течение июня 2017 были показы
    # https://yql.yandex-team.ru/Operations/WYLsdMqy15lftLNkXhIi-9SSlSaMSKZmkrir8dZRPkw=
    print STDERR "reading YT table... ";
    my $yt = Yandex::YT::TableReader->new('//home/direct/tmp/andreymak/DIRECT-68152_camps_no_behavior', format => 'json');
    my @cids;
    while (my $row = $yt->next()) {
        push @cids, $row->{cid};
    }

    return \@cids;
}
