#!/usr/bin/perl

=head1 DESCRIPTION

    --tt-name - имя шаблона
    --date-from - дата с которой смотреть статистику
    --date-to - дата по которую смотреть статистику, НЕ включительно

=cut

use Direct::Modern;

use List::Util qw/all/;

use lib '/var/www/ppc.yandex.ru/';
use my_inc '/var/www/ppc.yandex.ru', for => 'protected';
BEGIN { $ENV{SETTINGS_LOCAL_SUFFIX} = 'ROProd'; }
use Settings;
use ScriptHelper;
use Yandex::DateTime;
use Yandex::DBTools;

$SIG{__DIE__} = \&Carp::confess;

extract_script_params(
        "tt-name=s" => \my $tt_name,
        "date-from=s" => \my $date_from,
        "date-to=s" => \my $date_to,
    );

unless (all {defined} ($tt_name, $date_from, $date_to)) {
    die usage();
}

my $dt_to = date($date_to);
my $total_count = 0;
for (
    my $dt = date($date_from);
    $dt < $dt_to;
    $dt->add(days => 1)
) {
    my $count = get_one_field_sql(PPCLOG(), [
        "SELECT COUNT(*) FROM logmail_".$dt->ymd(''),
        WHERE => {
            template_name => $tt_name,
        }
    ]);
    say $dt->ymd()."\t".$count;
    $total_count += $count;
}

say "total count: $total_count";
