#! /usr/bin/perl 

use Direct::Modern;
use open ':std', ':utf8';

use Settings;
use my_inc '..';
use DDP;
use Text::CSV;
use Yandex::ListUtils qw/xminus/;
use Yandex::DBTools;
use ScriptHelper;
use Time::HiRes qw /usleep/;

use Stat::ReportMaster;
use Stat::Const;
use Stat::Tools;


die "please switch to roprod" unless $Settings::CONFIGURATION eq 'roprod';
my $DATE_FROM='2017-10-16';
my $DATE_TO='2017-11-15';

sub get_totals {
    my $UID = 1;
    my ($clientid, $uid) = (@_);

    my $report_opts = {
        attribution_model => undef,
        columns => ['sum'],
        columns_positions => [
            "shows",
            "clicks",
            "ctr",
            "sum",
            "av_sum",
            "fp_shows_avg_pos",
            "fp_clicks_avg_pos",
            "winrate",
            "bounce_ratio",
            "adepth",
            "aconv",
            "agoalcost",
            "agoalnum",
            "agoalroi",
            "agoalincome",
            "aprgoodmultigoal",
            "aprgoodmultigoal_cpa",
            "aprgoodmultigoal_conv_rate"
        ],
        date_from => $DATE_FROM,
        date_to => $DATE_TO,
        filters => {campaign => {eq => [ 15414652, 15414658, 15414661 ] } },
        group_by => [],
        group_by_date => "none",
        group_by_positions => [
            "campaign_type",
            "campaign",
            "tags",
            "adgroup",
            "banner",
            "banner_type",
            "contextcond_orig",
            "contexttype_orig",
            "match_type",
            "retargeting_coef",
            "targettype",
            "page_group",
            "page",
            "ssp",
            "region",
            "physical_region",
            "position",
            "click_place",
            "banner_image_type",
            "image_size",
            "device_type",
            "detailed_device_type",
            "connection_type",
            "gender",
            "age"
        ],
        page => 1,
        page_size => 100,
        with_discount => 1,
        with_nds => 0
    };

    my $dont_check_camp_type_by_role = "";
    my $dynamic_data_ref = \(undef);
    my $use_stat_iterator = "";
    
    #print(STDERR "clientid: $clientid, uid: $uid\n");
    my $cids = get_one_column_sql(PPC(ClientID => $clientid), ["SELECT cid FROM campaigns camp WHERE camp.statusActive = 'Yes' AND type NOT IN ('wallet') AND clientid = $clientid"]);
 
    #print(STDERR "got ".scalar(@$cids)." cids\n");
    $report_opts->{filters}->{campaign}->{eq} = $cids;
    my ($stat_data, $too_much_statistics_error) = eval {    Stat::ReportMaster::get_stat_report($UID, $uid, $report_opts, dynamic_data_ref => $dynamic_data_ref,
                                                                                                                      use_stat_iterator => $use_stat_iterator,
                                                                                                                      dont_check_camp_type_by_role => $dont_check_camp_type_by_role, ); 
    };

    return $stat_data->{totals}->{sum};
}


print(STDERR "fetching agency data...\n");
my $agency_data = get_all_sql(PPC(shard => 'all'), 
       [ "SELECT cl.clientid AS agency_client_id, u.login AS agency_login, u.email AS agency_email 
          FROM clients cl 
          INNER JOIN users u ON (u.uid = cl.chief_uid)", 
          where => { 'cl.country_region_id' => 159, 'cl.role' => 'agency' }
       ]
   );

my %indexed_agencies = (map { $_->{agency_client_id} => $_ } @{$agency_data});


print(STDERR "fetching clients data...\n");
my $client_data = get_all_sql(PPC(shard => 'all'),
       [ "SELECT cl.ClientID AS clientid, cl.agency_client_id AS agency_client_id, u.login AS subclient_login, u.email AS subclient_email, chief_uid, work_currency, count(camp.type) as geo_count
          FROM clients cl 
          INNER JOIN users u ON (u.uid = cl.chief_uid)
          LEFT JOIN  campaigns camp ON (camp.clientid = cl.clientid and camp.type = 'geo' and camp.statusActive = 'Yes')",
          where => { 'cl.role' => 'client', 'cl.agency_client_id' => [keys(%indexed_agencies)] },
          "GROUP BY clientid, agency_client_id, subclient_login, subclient_email"
       ]
);

my %indexed_clients = (map { $_->{clientid} => $_ } @{$client_data});

my @subclient_ids = keys(%indexed_clients);

print(STDERR scalar(@subclient_ids)." clients in total\n");

my $joined_subclient_ids = join(', ', @subclient_ids);

print(STDERR "fetching camps with feeds data...\n");
my $feed_info = get_all_sql(PPC(shard => 'all'),
       [
          "SELECT clientid, count(distinct cid) as feed_camps_count, group_concat(distinct cid separator ', ') as cids from 
           (SELECT cl.clientid, camp.cid  FROM 
             adgroups_dynamic gr_dyn
             INNER JOIN phrases p ON (p.pid = gr_dyn.pid)
             INNER JOIN campaigns camp ON (camp.cid = p.cid)
             INNER JOIN clients cl ON (cl.clientid = camp.clientid)
             WHERE cl.clientid IN (".$joined_subclient_ids.") AND camp.statusActive = 'Yes' and gr_dyn.feed_id IS NOT NULL
             GROUP BY clientid 
             UNION ALL 
             SELECT cl.clientid, camp.cid FROM 
             adgroups_performance gr_perf
             INNER JOIN phrases p ON (p.pid = gr_perf.pid)
             INNER JOIN campaigns camp ON (camp.cid = p.cid) 
             INNER JOIN clients cl ON (cl.clientid = camp.clientid)
             WHERE cl.clientid IN (".$joined_subclient_ids.") AND camp.statusActive = 'Yes' and gr_perf.feed_id IS NOT NULL
             GROUP BY clientid) t1 
           group by clientid"
       ]
);

my %indexed_feed_info = (map { $_->{clientid} => $_ } @{$feed_info});


print(STDERR "fetching camps with creatives info...\n");
my $creative_info = get_all_sql(PPC(shard => 'all'),
       [
           "SELECT clientid, count(distinct camp.cid) AS camp_with_creatives_count FROM 
            banners_performance bp 
            INNER JOIN campaigns camp ON (bp.cid = camp.cid) ",
            where => {'camp.clientid' => \@subclient_ids, 'camp.statusActive' => 'Yes'},
            "GROUP BY clientid"
       ]
);

my %indexed_creative_info = (map { $_->{clientid} => $_ } @{$creative_info});

print(STDERR "fetching smart camps data...\n");
my $smart_camps_info = get_all_sql(PPC(shard => 'all'),
      [
           "SELECT clientid, count(distinct camp.cid) as smart_camps_count 
            FROM campaigns camp",
            where => {'camp.type' => 'performance', 'camp.clientid' => \@subclient_ids, 'camp.statusActive' => 'Yes'},
            "GROUP BY clientid"
      ]
);

my %indexed_smart_camps_info = (map { $_->{clientid} => $_ } @{$smart_camps_info});

print(STDERR "fetching total camps data...\n");
my $total_camps_info = get_all_sql(PPC(shard => 'all'),
       [
            "SELECT clientid, count(1) as total_camp_count from campaigns camp",
            where => {clientid => \@subclient_ids, 'camp.statusActive' => 'Yes'},
            "GROUP BY clientid"
       ]
);

my %indexed_total_camps_info = (map { $_->{clientid} => $_ } @{$total_camps_info});

print("AGENCY_LOGIN, AGENCY_EMAIL, CLIENT_LOGIN, CLIENT_EMAIL, CAMP_WITH_CREATIVES, CAMP_WITH_FEEDS, SMART_CAMPAIGNS, GEO_CAMPAIGNS, TOTAL_CAMPAIGNS, TOTAL_MONEY($DATE_FROM-$DATE_TO), WORK_CURRENCY\n");
foreach my $client_id (keys %indexed_clients) {
    my $client = $indexed_clients{$client_id};
    my $agency_id = $client->{agency_client_id};
    my $agency = $indexed_agencies{$agency_id};
    $agency->{has_clients} = 1;

    my $total_money = get_totals($client_id, $client->{chief_uid});

    my $feed_camps = $indexed_feed_info{$client_id};
    my $creative_camps = $indexed_creative_info{$client_id};
    my $smart_camps = $indexed_smart_camps_info{$client_id};
    my $camp_totals = $indexed_total_camps_info{$client_id};

    my @row_array = (
        $agency->{agency_login}, $agency->{agency_email},
        $client->{subclient_login}, $client->{subclient_email},
        defined($creative_camps) ? $creative_camps->{camp_with_creatives_count} : 0,
        defined($feed_camps) ? $feed_camps->{feed_camps_count} : 0,
        defined($smart_camps) ? $smart_camps->{smart_camps_count} : 0,
        $client->{geo_count},
        defined($camp_totals) ? $camp_totals->{total_camp_count} : 0,
        $total_money,
        defined($client->{work_currency}) ? $client->{work_currency} : 'YND_FIXED'
    );
    print(join(', ', @row_array)."\n");
    usleep(1000);#чтоб не слишком часто ходить в БК за статистикой
}

foreach my $agency_id (keys %indexed_agencies) {
    my $agency = $indexed_agencies{$agency_id};
    if (!defined($agency->{has_clients})) {
        my @row_array = (
            $agency->{agency_login}, $agency->{agency_email},
            'NO_DATA', 'NO_DATA',
            'NO_DATA',
            'NO_DATA',
            'NO_DATA',
            'NO_DATA',
            'NO_DATA',
            'NO_DATA',
            'NO_DATA'
        );
        print(join(', ', @row_array)."\n");
    }
}
