#!/usr/bin/perl

use common::sense;
use JSON;
use List::MoreUtils 'uniq';
use List::Util 'sum';
BEGIN { $ENV{SETTINGS_LOCAL_SUFFIX} = 'ROProd'; }
use my_inc '/var/www/ppc.yandex.ru', for => 'protected';
use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use DBStat;
use Data::Leaf::Walker;
use Scalar::Util qw/looks_like_number/;


=head1 USAGE

m -B pr:ppchouse:logs "select cluid, cid, log_time, param from ppclog_api where log_date > today() - 90 and cmd = 'campaigns.update'
and visitParamHas(param, 'BiddingStrategy')" > campaigns.update.log

cat campaigns.update.log | ./DIRECT-73146.pl | yt write --format json [home/direct/tmp/icenine/campaigns_update]

=cut

$|++;

my $json = JSON->new()->utf8(1);

my %fields = map { $_ => 1 } qw/
int_Network_AverageCpa_AverageCpa int_Network_AverageCpa_BidCeiling Network_AverageCpa_GoalId int_Network_AverageCpa_WeeklySpendLimit
int_Network_AverageCpc_AverageCpc int_Network_AverageCpc_WeeklySpendLimit int_Network_AverageCpi_AverageCpi
int_Network_AverageCpi_BidCeiling int_Network_AverageCpi_WeeklySpendLimit int_Network_AverageRoi_BidCeiling Network_AverageRoi_GoalId
int_Network_AverageRoi_Profitability int_Network_AverageRoi_ReserveReturn int_Network_AverageRoi_RoiCoef
int_Network_AverageRoi_WeeklySpendLimit int_Network_NetworkDefault_BidPercent int_Network_NetworkDefault_LimitPercent
int_Network_WbMaximumAppInstalls_BidCeiling int_Network_WbMaximumAppInstalls_WeeklySpendLimit int_Network_WbMaximumClicks_BidCeiling
int_Network_WbMaximumClicks_WeeklySpendLimit int_Network_WbMaximumConversionRate_BidCeiling Network_WbMaximumConversionRate_GoalId
int_Network_WbMaximumConversionRate_WeeklySpendLimit int_Network_WeeklyClickPackage_AverageCpc int_Network_WeeklyClickPackage_BidCeiling
int_Network_WeeklyClickPackage_ClicksPerWeek int_Search_AverageCpa_AverageCpa int_Search_AverageCpa_BidCeiling Search_AverageCpa_GoalId
int_Search_AverageCpa_WeeklySpendLimit int_Search_AverageCpc_AverageCpc int_Search_AverageCpc_WeeklySpendLimit
int_Search_AverageCpi_AverageCpi int_Search_AverageCpi_BidCeiling int_Search_AverageCpi_WeeklySpendLimit int_Search_AverageRoi_BidCeiling
Search_AverageRoi_GoalId int_Search_AverageRoi_Profitability int_Search_AverageRoi_ReserveReturn int_Search_AverageRoi_RoiCoef
int_Search_AverageRoi_WeeklySpendLimit int_Search_WbMaximumClicks_BidCeiling int_Search_WbMaximumClicks_WeeklySpendLimit
int_Search_WbMaximumConversionRate_BidCeiling Search_WbMaximumConversionRate_GoalId int_Search_WbMaximumConversionRate_WeeklySpendLimit
int_Search_WeeklyClickPackage_AverageCpc int_Search_WeeklyClickPackage_BidCeiling int_Search_WeeklyClickPackage_ClicksPerWeek
Network_AverageCpa_BidCeiling Network_AverageCpa_WeeklySpendLimit Network_AverageCpc_WeeklySpendLimit Network_AverageCpi_BidCeiling
Network_AverageCpi_WeeklySpendLimit Network_AverageRoi_BidCeiling Network_AverageRoi_Profitability Network_AverageRoi_WeeklySpendLimit
Network_BiddingStrategyType Network_WbMaximumClicks_BidCeiling Network_WbMaximumConversionRate_BidCeiling
Network_WeeklyClickPackage_AverageCpc Network_WeeklyClickPackage_BidCeiling Search_AverageCpa_BidCeiling Search_AverageCpa_WeeklySpendLimit
Search_AverageCpc_WeeklySpendLimit Search_AverageCpi_BidCeiling Search_AverageCpi_WeeklySpendLimit Search_AverageRoi_BidCeiling
Search_AverageRoi_Profitability Search_AverageRoi_WeeklySpendLimit Search_BiddingStrategyType Search_WbMaximumClicks_BidCeiling
Search_WbMaximumConversionRate_BidCeiling Search_WeeklyClickPackage_AverageCpc Search_WeeklyClickPackage_BidCeiling
/;

sub get_sql
{
    my (@sum_keys, @lag_keys, @lag2_keys);
    for my $field (sort keys %fields) {
        if ($field =~ /^int/) {
            push @sum_keys, "sum(${field}_incr) as ${field}_incr", "sum(${field}_decr) as ${field}_decr";
            push @lag_keys,
                "if ($field > ${field}_prev, 1,0) as ${field}_incr",
                "if ($field < ${field}_prev, 1,0) as ${field}_decr";
        }
        else {
            push @sum_keys, "sum(${field}_changed) as ${field}_changed";
            push @lag_keys, "if ($field <> ${field}_prev, 1,0) as ${field}_changed";
        }
        push @lag2_keys, $field, "LAG($field,1) over w as ${field}_prev";
    }
    print "insert into [home/direct/tmp/icenine/campaigns_update2] with truncate
    select log_money, "
        . (join ", ", @sum_keys)
        . "
        from ( select log_money, "
        . (join ", ", @lag_keys)
        . "
        from (select cid, log_money, "
        . (join ", ", @lag2_keys)
        . "
        from  [home/direct/tmp/icenine/campaigns_update] WINDOW w as (
            PARTITION BY cid
            order by log_time
        )
        )
        )
        GROUP BY log_money"

}

sub get_spent_money
{
    my ($uid) = @_;
    state $cache = {};
    if (exists $cache->{$uid}) {
        return $cache->{$uid};
    }
    warn "get money for uid = $uid\n";
    my $oids = get_all_sql(PPC(uid => $uid), ["select OrderID from campaigns", where => { uid => SHARD_IDS, OrderID__gt => 0 }]);
    # { use Data::Dump 'pp'; my $p = pp({ oids => $oids, uid => $uid }); $p =~ s#\\x\{([\da-f]{2,4})\}#chr(hex($1))#gei; print STDERR "$p\n"; } # NO_PRODUCTION

    my $stat = DBStat->get_orders_stat_date_fetch_bs($oids, '2017-09-11', '2017-12-11', single_currency => 1);

    my $sum = int(sum(map { $_->{Cost} } map { values %$_ } values %$stat));
    $cache->{$uid} = $sum;
    return $sum;
}

get_sql(); exit;

while (<>) {
    my ($uid, $cid, $log_time, $param) = split /\t/, $_, 4;
    # { use Data::Dump 'pp'; my $p = pp({ args => [ $uid, $cid, $log_time, $param ] }); $p =~ s#\\x\{([\da-f]{2,4})\}#chr(hex($1))#gei; print STDERR "$p\n"; } # NO_PRODUCTION
    $uid = eval { $json->decode($uid) };
    next unless @$uid;
    my $money = sum(map {get_spent_money($_)} @$uid);

    my $log_money = 2**int(log($money+1)/log(2));

    # $money = int($money/5000)*5000;
    $param =~ s!\\\\\"!\\\"!g;
    $param =~ s!\\'!!g;
    $param =~ s!\\\\\\"!\"!g;
    my $row = eval { $json->decode($param); };
    if ($@) {
        warn "failed $_: $@\n";
    }
    unless ($row) {
        warn "no params @ $.\n";
        next;
    }
    
    for my $camp (@{$row->{Campaigns}}) {
        for my $k (keys %$camp) {
            if ($camp->{$k}->{BiddingStrategy}) {
                my $long_params = get_keys2($camp->{$k}->{BiddingStrategy});
                print $json->encode({ %$long_params, money => $money +0, log_money => $log_money, uid => $uid+0,
                        cid => $camp->{Id}+0, log_time => $log_time });
                # for my $c (@$cid) {
                #     print $json->encode({ %$long_params, money => $money +0, log_money => $log_money, uid => $uid+0, cid => $c, log_time => $log_time });
                # }
                print "\n";
            }
        }

    }
    if ($. > 1 && $. % 10_000 == 0) {
        warn "line $.\n";
        # last;
    }
}

sub get_keys2
{
    my ($r) = @_;
    my $res = {};
    my $w = Data::Leaf::Walker->new($r);
    while (my ($k, $v) = $w->each) {
        my $name = join '_', @$k;
        if (looks_like_number($v)) {
            $name = "int_$name";
            $v = $v + 0;
        }
        $res->{$name} = $v;
        for my $f (keys %fields) {
            if ($f =~ /^int_/) {
                $res->{$f} //= 0;
            }
            else {
                $res->{$f} //= '';
            }
        }
    }
    return $res;
}

sub get_keys
{
    my ($r, $ar) = @_;
    return unless ref $r eq 'HASH';
    $ar //= [];
    push @$ar, keys %$r;
    while (my ($k, $v) = each %$r) {
        if (ref $$r{$k} eq 'HASH') {
            get_keys($$r{$k}, $ar);
        }
        elsif (ref $$r{$k} eq 'ARRAY') {
            for my $i (@{$r->{$k}}) {
                get_keys($i, $ar);
            }
        }
    }
    return $ar;
}
