#! /usr/bin/perl 

use Direct::Modern;
use open ':std', ':utf8';

use Settings;
use my_inc '..';
use DDP;
use Text::CSV;
use Yandex::ListUtils qw/xminus/;
use Yandex::DBTools;


die "please switch to roprod" unless $Settings::CONFIGURATION eq 'roprod';

#Исходные clientid; получены копированием в файл (к примеру,  1.txt) и склейкой: 'paste -d, -s 1.txt > DIRECT-69355_clientids.txt'
#Часть clientid в БД Директа отсутствует; для таких выдается 'UNKNOWN CLIENT', 'UNKNOWN SCHEDULE', 'UNKNOWN CURRENCY'

my @client_ids = (
    1315486,1381169,1549128,1552926,1598230,1659605,1727111,1853732,1911806,1961679,1993387,2028334,2077229,2092920,2140692,2142854,
    2161086,2204667,2206056,2222121,2230717,2264416,2274364,2389240,2451575,2572287,2752000,2777758,2829868,2989656,2989688,2989740,
    2989751,2989785,3067081,3291964,3332328,3521795,3599253,3665261,3952090,4044213,4344257,4673358,4861525,5159326,5313004,5344632,
    5445121,5702150,5825221,5836325,6080196,6108673,6489471,6725397,7509668,7532484,7532490,7532500,7532503,7532505,7532521,7532525,
    7532573,7532587,7532594,7576794,7685132,7685137,7685169,7763935,7855330,7890926,7898280,7952356,7984735,9307763,9542844,9543022,
    9543180,9710757,9711933,9906472,10641505,10643095,10643448,10643736,11346720,11916690,12322830,13043321,13408850,14042367,14744352,
    15121147,15343121,20857206,28085316,30657913,32123411,32404442,33156368,33503446,33543545,33590383,33848195,34100065,34501232,34738369,34738574
);


my $existing_clids = get_one_column_sql(PPC(shard => 'all'), 
                      ["SELECT clientid from clients cl", where => {'cl.clientid' => \@client_ids} ] );
my $unknown_clids = xminus(\@client_ids, $existing_clids);
print(STDERR "discovered unknown client ids:".join(", ", @{$unknown_clids})."\n");

my $clients_data = get_all_sql(PPC(shard => 'all'), 
       [ "SELECT cl.clientid AS client_id, group_concat(concat(date_format(cl_nds.date_from, '%d.%m.%Y'), '-', date_format(cl_nds.date_to, '%d.%m.%Y'), ':', format(cl_nds.nds, 2) ) ORDER BY cl_nds.date_to SEPARATOR '; ') AS client_nds_schedule, 
          IFNULL(cl.work_currency, '') AS client_work_currency
          FROM clients cl 
          LEFT JOIN client_nds cl_nds on (cl.clientid = cl_nds.clientid)", 
          where => { 'cl.clientid' => \@client_ids },
          "GROUP BY cl.clientid" 
       ]
   );

my %indexed_clients = ( map { $_->{client_id} => $_ } @{$clients_data} );


my @unknown_client_row_array = ('UNKNOWN CLIENT', 'UNKNOWN SCHEDULE', 'UNKNOWN CURRENCY');
print("CLIENT_ID, CLIENT_NDS_SCHEDULE, CLIENT_WORK_CURRENCY\n");


foreach my $src_clientid (@client_ids) {
    my $client_row = $indexed_clients{$src_clientid};
    my $client_row_array;

    if (defined($client_row)) {
        my @client_data = @{$client_row}{ qw/ client_id client_nds_schedule client_work_currency/ };
        @client_data = map { defined($_) ? $_ : '' } @client_data;
        $client_row_array = \@client_data;
    } else { 
        $client_row_array = \@unknown_client_row_array;
    }
    print(join(", ", @{$client_row_array})."\n");
}

