package Plack::UTF8Request;

=head1 NAME

=encoding utf8

Plack::UTF8Request - Plack::Request, делающий всё в UTF8

=head1 DESCRIPTION

    Plack::UTF8Request — обёртка вокруг Plack::Request, устанавливающая
    флаг utf8 на параметры и, если значение параметра — невалидный UTF, то 
    перекодирует из cp1251

=cut

use strict;
use warnings;

use Encode;
use Hash::MultiValue;

use base qw/Plack::Request/;

sub new {
    my $proto = shift;
    my $class = ref($proto) || $proto;
    bless $class->SUPER::new(@_);
}

=pod

    копия из Plack::Request
    но если оставить метод там - испортится $self->env->{'plack.request.merged'} - 
    он будет utf-изирован, из-за того, что query_parameters/body_parameters
    вернут utf-ные значения

=cut

sub parameters {
    my $self = shift;
    $self->env->{'plack.utf8request.parameters'} ||= do {
        my $query = $self->query_parameters;
        my $body  = $self->body_parameters;
        Hash::MultiValue->new($query->flatten, $body->flatten);
    };
}

sub query_parameters {
    my $self = shift;
    return $self->env->{'plack.utf8request.query_parameters'} ||= _decode_hash_multivalue($self->SUPER::query_parameters(@_));
}

sub body_parameters {
    my $self = shift;
    return $self->env->{'plack.utf8request.body_parameters'} ||= _decode_hash_multivalue($self->SUPER::body_parameters(@_));
}

##############
# внутренности

# создаёт новый Hash::MultiValue, с utf-ными ключами и значениями
sub _decode_hash_multivalue {
    my $ret = Hash::MultiValue->new();
    shift->each(sub {
            $ret->add($_[0], _decode_scalar($_[1]));
        }
    );
    return $ret;
}

sub _decode_scalar {
    my ($str) = @_;
    if (!Encode::is_utf8($str)) {
        Encode::_utf8_on($str);
        if (!Encode::is_utf8($str, 1)) {
            Encode::_utf8_off($str);
            $str = Encode::decode('cp1251', $str);
        }
    }
    return $str;
}

1;
