#!/usr/bin/perl

=head1 NAME

    expand_acl_rules.pl

=head1 DESCRIPTION

    Раскрываем макросы Голема и рекурсивно описанные правила
    для P::M::ACL (поддерживается только YAML)

    Читаем данные из файла $ARGV[0], пишем в $ARGV[0].expanded

=cut

use strict;
use warnings;

use File::Slurp;
use YAML;
use Yandex::Golem qw/firewall_expand_macro/;

my $input = read_file($ARGV[0], binmode => ':utf8');
my $rules = YAML::Load($input);

my $expanded_rules = {};

for my $name (keys %$rules) {
    my $already_included = {$name => 1};
    my $rule = $rules->{$name};

    $expanded_rules->{$name} = [map {expand($_, $rules, $already_included)} @$rule];
}

write_file("$ARGV[0].expanded", {atomic => 1, binmode => ':utf8'}, YAML::Dump($expanded_rules));


sub expand
{
    my ($item, $rules, $already_included) = @_;

    if (my $included_rule = $rules->{$item}) {
        if ($already_included->{$item}) {
            return ();
        } else {
            $already_included->{$item}++;
            return map {expand($_, $rules, $already_included)} @$included_rule;
        }
    } elsif ($item =~ /^_.*_$/) {
        return @{firewall_expand_macro($item)};
    } else {
        return $item;
    }
}
