#!/usr/bin/perl

=head1 NAME

    check_acl_ok.pl

=head1 DESCRIPTION

    Проверка корректности проверки ACL.
    Может принимать первым аргументом имя YAML-файла в формате:
    
        whitelist:
            - <имя или адрес хоста>
            - ...
        hosts_to_test:
            - ...
            - ...

    Если имя не задано, то проверяет хосты из списка по умолчанию.
    Для каждого имени хоста из списка получаем IP-адреса (v4 и v6, если есть) и передаём их в acl_ok.

=cut

use strict;
use warnings;

use List::MoreUtils qw/uniq/;
use Plack::Middleware::ACL;
use Socket qw/getaddrinfo getnameinfo NI_NUMERICHOST/;
use YAML;

# grep -P '^\s*[a-z0-9\.-]+\s*$' Intapi.pm | awk '{print $1}' | sort | uniq
my $hosts_from_intapi = [qw/
    127.0.0.1
    abyss.precise.bshive.yandex.net
    antilost2.bshive.yandex.net
    antilost.bshive.yandex.net
    api-metrika3.yandex.ru
    beta.geocontext.yandex.ru
    beta.partner.yandex.ru
    beta-precise.geocontext.yandex.ru
    bmfront01f.yandex.net
    bmgen01g.yandex.ru
    bmgen01h.yandex.ru
    bmgen01t.yandex.ru
    bmgen02e.yandex.ru
    bmgen-dev01e.yandex.ru
    bmlink01f.yandex.ru
    bmlink01g.yandex.ru
    bmlink01h.yandex.ru
    bmlink01t.yandex.ru
    bmlink02f.yandex.ru
    bmlink02g.yandex.ru
    bmlink02h.yandex.ru
    bmlink03f.yandex.ru
    bmlink03g.yandex.ru
    bmlink03h.yandex.ru
    bmlink04f.yandex.ru
    bmlink04g.yandex.ru
    bmlink04h.yandex.ru
    bmlink05f.yandex.ru
    bmlink05g.yandex.ru
    bmlink05h.yandex.ru
    bscoll.yandex.ru
    bsint01d.yandex.ru
    bsint01g.yandex.ru
    bsint01i.yandex.ru
    bsint02e.yandex.ru
    bsint02f.yandex.ru
    bssoap01d.yandex.ru
    bssoap01e.yandex.ru
    bssoap01f.yandex.ru
    bssoap01g.yandex.ru
    bssoap01h.yandex.ru
    bssoap01i.yandex.ru
    catalogia-media01e.yandex.ru
    catalogia-media-dev01e.yandex.ru
    ci01d.yandex.ru
    ci01e.yandex.ru
    ci01f.yandex.ru
    ci02d.yandex.ru
    ci02e.yandex.ru
    ci02f.yandex.ru
    ci03d.yandex.ru
    ci03e.yandex.ru
    ci03f.yandex.ru
    ci04d.yandex.ru
    ci04e.yandex.ru
    ci04f.yandex.ru
    dev-partner.yandex.ru
    direct-mod-test.yandex.ru
    greed1e.yandex.ru
    greed1f.yandex.ru
    greed1g.yandex.ru
    greed2e.yandex.ru
    greed2f.yandex.ru
    greed2g.yandex.ru
    greed3e.yandex.ru
    greed3f.yandex.ru
    greed3g.yandex.ru
    gtx01e.yandex.ru
    gtx01f.yandex.ru
    idm01d.cs-minitools01d.yandex.ru
    idm01h.cs-minitools01h.yandex.ru
    metrika2-1.yandex.ru
    metrika2-2.yandex.ru
    metrika2-3.yandex.ru
    metrika3-1.yandex.ru
    metrika3-2.yandex.ru
    metrika-load.yandex.ru
    metrika-ng1-1.yandex.ru
    metrika-ng1-2.yandex.ru
    metrika-ng2-1.yandex.ru
    metrika-ng2-2.yandex.ru
    metrika-ng3-1.yandex.ru
    metrika-ng3-2.yandex.ru
    metrika-ps.haze.yandex.ru
    metrika-test.yandex.ru
    mfas001.yandex.ru
    mfas002.yandex.ru
    mfas005.search.yandex.net
    modback01d.yandex.ru
    modback01e.yandex.ru
    mtback01d.yandex.ru
    mtback01ep.yandex.ru
    mtback01e.yandex.ru
    mtback01i.yandex.ru
    mtback02d.yandex.ru
    mtback02e.yandex.ru
    mtback02i.yandex.ru
    mtbot1.yandex.ru
    mtbot2.yandex.ru
    mtcommon01-2.yandex.ru
    mtcommon01i.yandex.ru
    mtcommon01t.yandex.ru
    mtconv1.yandex.ru
    mtconv2.yandex.ru
    partnerscr01f.yandex.ru
    pi01d.yandex.ru
    pi01f.yandex.ru
    pi02d.yandex.ru
    pi02f.yandex.ru
    pi-tmp01e.yandex.ru
    pi-tmp01f.yandex.ru
    ppcback01e.yandex.ru
    ppcback01f.yandex.ru
    ppcback01i.yandex.ru
    ppcdev1.yandex.ru
    ppcdev2.yandex.ru
    ppcdev3.yandex.ru
    ppcdev-hardy.yandex.ru
    ppcdev.yandex.ru
    ppcmod01d.yandex.ru
    ppcmod01d.yandex-team.ru
    ppcmod01e.yandex.ru
    ppcmod01e.yandex-team.ru
    ppcmoddev-precise.yandex.ru
    ppcmoddev.yandex.ru
    ppcsandbox-front01e.yandex.ru
    ppcsandbox-front01f.yandex.ru
    ppctest-load2-front.yandex.ru
    ppctest-load-front.yandex.ru
    ppctest-sandbox1-front.yandex.ru
    ppctest-sandbox2-front.yandex.ru
    ppctest-ts1-front.yandex.ru
    ppctest-ts2-front.yandex.ru
    test-direct.yandex.ru
    test-geocontext-precise.yandex.ru
    test.geocontext.yandex.ru
    testing.yacobot01t.yandex.ru
    yacoads01d.yandex.ru
    yacoads01e.yandex.ru
    yacoads01f.yandex.ru
    yacoads1.yandex.ru
    yacobot01t.yandex.ru
    yacobot02t.yandex.ru
    yacobot03t.yandex.ru
    yacobot04t.yandex.ru
    yacobotarc.yandex.ru
    yacotools01d.yandex.ru
    yacotools02f.yandex.ru
    yacotools02g.yandex.ru
    zurom.bshive.yandex.net
/];

my $test_plan;
if ($ARGV[0]) {
    $test_plan = YAML::LoadFile($ARGV[0]);
} else {
    $test_plan = { hosts_to_test => [ @$hosts_from_intapi ], whitelist => [ @$hosts_from_intapi ] };
}

my $hosts_to_test = $test_plan->{hosts_to_test};
my $whitelist = $test_plan->{whitelist};

for my $host (@$hosts_to_test) {
    my $err;
    my @res;
    ($err, @res) = getaddrinfo($host, 0);
    if ($err) {
        print "Skipping $host: $err\n";
        next;
    }
    my @binaddrs = uniq map {$_->{addr}} @res;
    my @addrs;
    foreach (@binaddrs) {
        my $ip;
        ($err, $ip) = getnameinfo($_, NI_NUMERICHOST);
        die $err if $err;
        print "$ip ";
        if ($host =~ /^[a-z0-9.-]+$/ && $host =~ /[a-z]/) {
            print "($host) ";
        }
        my $ok = eval {Plack::Middleware::ACL::acl_ok($ip, $whitelist)};
        if ($@) {
            print "error: $@";
            next;
        }
        if ($ok) {
            print "ok\n";
        } else {
            print "FAIL\n";
        }
    }
}
