package Plack::Middleware::AuthAdwords;
use parent qw/Plack::Middleware/;

# $Id$

use strict;
use warnings;

use Plack::Request;
use Plack::Response;
use URI::Escape qw/uri_escape_utf8 uri_unescape/;

use Yandex::Blackbox;
use Yandex::SendMail;


=head2 call

    Коллбэк для Plack::Middleware

=cut

sub call
{
    my ($self, $env) = @_;

    my $yandex_domain = 'yandex.ru';
    $yandex_domain = $1 if $env->{HTTP_HOST} =~ /(yandex\.(?:ua|kz|by))/;
    $env->{yandex_domain} = $yandex_domain;

    my $request = Plack::Request->new($env);
    my $session_id = $request->cookies->{Session_id} || '';
    my $nocookiesupport = $request->param('nocookiesupport') || '';
    my $noauth_expired = 0;
    my $retpath = $env->{'psgi.url_scheme'}.'://'.$env->{HTTP_HOST}.$env->{REQUEST_URI};
    if ($session_id) {
        my $bb_res = eval { bb_sessionid($session_id, $env->{REMOTE_ADDR}, 'sprav.'.$env->{yandex_domain}, [$BB_LOGIN, $BB_FIO, $BB_EMAIL, $BB_SUID_WEBMASTER]) };
        if ($@) {
            send_alert($@, 'BlackBox error'); 
            die $@;
        }

        if ($bb_res->{valid}) {
            $env->{operator_uid}   = $bb_res->{uid} || $bb_res->{liteuid};
            $env->{operator_login} = $bb_res->{dbfield}->{$BB_LOGIN};
            $env->{operator_fio}   = $bb_res->{dbfield}->{$BB_FIO};
            $env->{operator_email} = $bb_res->{dbfield}->{$BB_EMAIL};
            $env->{display_name}   = $bb_res->{display_name};
            $env->{operator_is_webmaster} = $bb_res->{dbfield}->{$BB_SUID_WEBMASTER};
        }

        if ($bb_res->{status}{content} =~ /NOAUTH/i && $bb_res->{age} && $bb_res->{age} > $NOAUTH_TIMEOUT) {
            $noauth_expired = 1;
        }
        if ($bb_res->{renew} && $request->method eq 'GET') {
            if ($yandex_domain ne 'yandex.ru') {
                return pass_redirect($retpath, $yandex_domain);
            } else {
                my $res = Plack::Response->new();
                $res->redirect($request->scheme.'://passport.'.$yandex_domain.'/?mode=auth&retpath='.uri_escape_utf8($retpath));
                return $res->finalize;
            }
        }
    }
    if ($yandex_domain ne 'yandex.ru' && !$session_id && $nocookiesupport ne 'yes' || $noauth_expired) {
        return pass_redirect($retpath, $yandex_domain);
    }
    return $self->app->($env);
}


=head2 pass_redirect
    
    Редирект на pass.yandex.*

=cut

sub pass_redirect
{
    my ($retpath, $yandex_domain) = @_;

    my $res = Plack::Response->new();
    $res->cookies->{Cookie_check} = {
        value   => 'CookieChecked',
        path    => '/',
        domain  => ".$yandex_domain",
        expires => undef,
    };
    $res->redirect('http://pass.'.$yandex_domain.'/?retpath='.uri_escape_utf8($retpath));
    return $res->finalize;
}

1;
