package Plack::Middleware::Captcha;
use base qw/Plack::Middleware/;

use Plack::Util::Accessor qw/checker display_captcha/;

# $Id$

=head1 NAME

    Plack::Middleware::Captcha

=head1 DESCRIPTION

    Принимает два именованныx параметра:

    checker - ссылка на объект, который умеет
      ->check($env) - проверять, нужно ли показать пользователю капчу. 1 - нужно
      ->on_recognition($env) - колбэк, вызываемый при успешном распозновании капчи

    display_captcha($env, $vars) - коллбэк, выводящий капчу
    в vars есть ключи:
      captcha_id, captcha_url       - параметры сгенерированной капчи
      request_path, request_method  - параметры запроса пользователя
      FORM                          - CGI параметры

=cut


use strict;
use warnings;

use Data::Dumper;

use Plack::UTF8Request;

use Yandex::Captcha;

use utf8;


=head2 call

    Коллбэк для Plack::Middleware

=cut
sub call
{
    my ($self, $env) = @_;

    my $show_captcha_flag = $self->checker->check($env);

    if ($show_captcha_flag) {
        if ($self->is_good_captcha_code($env)) {
            # код введён правильно
            $self->checker->on_recognition($env) if $self->checker->can("on_recognition");
        } else {
            # нет кода или код введён неправильно
            return $self->show_captcha($env);
        }
    }
    return $self->app->($env);
}

=head2 is_good_captcha_code

    Проверка введённого кода

=cut
sub is_good_captcha_code {
    my ($self, $env) = @_;

    my $r = Plack::UTF8Request->new($env);

    if ($r->param('captcha_id') && $r->param('captcha_code')) {
        return Yandex::Captcha::check_captcha($r->param('captcha_id'), $r->param('captcha_code'));
    } else {
        return 0;
    }
}

=head2 show_captcha

    Сгенерировать новую капчу, вызвать метод для отображения странички с капчей

=cut
sub show_captcha {
    my ($self, $env) = @_;

    my $r = Plack::UTF8Request->new($env);
    
    # undef - mean use default captcha type
    my ($capid, $capurl) = Yandex::Captcha::get_captcha_id(undef, https => 'on');
    my $vars = {
        captcha_id => $capid,
        captcha_url => $capurl,
        request_path => $r->uri->path,
        request_method => $r->method,
        FORM => $r->parameters,
    };

    return $self->display_captcha->($env, $vars);
}

1;
