package Plack::Middleware::CheckTVM2Ticket;
use base qw/Plack::Middleware/;

=head1 NAME

    Plack::Middleware::CheckTVM2Ticket -- проверка TVM-тикета

=head1 SYNONPSIS

    enable 'CheckTVM2Ticket', app_id => '2000390', tvmtool_url => '127.0.0.1:7007', tvm_token_file => '/etc/direct-tokens/tvmtool';

=head1 DESCRIPTION


=cut


use strict;
use warnings;

use HTTP::Request;
use JSON;
use Plack::Request;
use Plack::Util::Accessor qw/app_id tvmtool_url tvmtool_token_file/;
use Yandex::HTTP;
use Yandex::LiveFile;

use utf8;

use feature 'state';

our $TVMTOOL_URL;
our $TVMTOOL_TOKEN_FILE;

sub call {
    my ($self, $env) = @_;
    my $forbidden_response = sub { return [403, ['Content-Type' => 'text/plain'], [$_[0] || "Forbidden"]] };
    $TVMTOOL_URL = $self->tvmtool_url // 'http://127.0.0.1:7077';
    $TVMTOOL_TOKEN_FILE = $self->tvmtool_token_file // '/etc/direct-tokens/tvmtool';
    my $req = Plack::Request->new($env);
    # если кто-то раньше проставил флаг skip_tvm -- ничего не проверяем
    # это удобно для того, чтобы в одной и той же ручке старые потребители могли ходить без tvm (их внесем в исключения), а новые должны были передавать tvm-тикеты
    # в intapi Директа skip_tvm выставляет Plack::Middleware::ACL
    if (exists $env->{cmd_params} && exists $env->{cmd_params}->{tvm2_allow_ids} && !$env->{skip_tvm}) {
        my %is_allowed = map {$_ => 1} @{$env->{cmd_params}->{tvm2_allow_ids}};
        my $ticket = $req->header('X-Ya-Service-Ticket');
        if (!$ticket) {
            return $forbidden_response->("no ticket");
        }
        my $resp = call_tvmtool_checksrv(dst => $self->app_id, ticket => $ticket);
        my $tvmtool_response_hash = eval { from_json($resp->{content}) } // {};   # в случае ошибки может возвращать не-json и это обрабатывается далее
        my $tvmtool_error = $tvmtool_response_hash->{error} // '';

        if ($resp->{is_success}) {
            my $src = $tvmtool_response_hash->{src};
            die "unexpected error: tvmtool response ok, but contains no src" unless $src;
            if (! $is_allowed{$src}) {
                return $forbidden_response->("client $src is not allowed");
            }
        } elsif ($resp->{headers}->{Status} eq '403' && $tvmtool_error =~ /^(expired ticket|wrong ticket dst, expected [0-9]+, got [0-9]+|invalid (signature|ticket) format|unsupported ticket version)$/i) {
            return $forbidden_response->($tvmtool_error);
        } else {
            die "unexpected tvmtool response: " . $resp->{headers}->{Reason} . "\ncontent: " . ($resp->{content} // '');
        }
    }
    return $self->app->($env);
}

sub call_tvmtool_checksrv {
    my %O = @_;

    state $token_file;
    $token_file //= Yandex::LiveFile->new(filename => $TVMTOOL_TOKEN_FILE);
    my $token = $token_file->data;

    return Yandex::HTTP::http_parallel_request(GET =>
        {1 => {
            url => "$TVMTOOL_URL/tvm/checksrv?dst=$O{dst}"
        }},
        timeout => 5,
        headers => {'X-Ya-Service-Ticket' => $O{ticket}, 'Authorization' => $token},
    )->{1};
}

1;
