package Plack::Middleware::DetermineCmd;

use strict;
use warnings;

use URI::Escape;

use Yandex::HashUtils;

use base qw/Plack::Middleware/;
use Plack::Util::Accessor qw/urlmap/;

# $Id$

=head1 NAME

    Plack::Middleware::DetermineCmd - определение имени контролера по урлу и cgi параметрам

=head1 DESCRIPTION

    Параметры:
    urlmap - ссылка на массив массивов. Пробегается строго по очереди до первого совпадения.
        первый элемент внутреннего массива может быть
            - строкой - проверяем урл на частичное совпадение с начала
            - регулярным выражением - проверяем его, если подходит - результат _именованного_ матча записываем в cmd_params
        второй элемент внутреннего массива может быть
            - строкой - просто записываем эту строку в $env->{cmd}
            - ссылкой на хэш
                cgi_param - получаем cmd из соответствующего cgi-параметра
                cmd - строка, которая просто записывается в $env->{cmd}
                default - строка, умолчательное значение cmd
                params - ссылка на хеш параметров, которые изначально записываются в $env->{cmd_params}

=cut


use strict;
use warnings;

use utf8;

=head2 call

    Коллбэк для Plack::Middleware

=cut

sub call
{
    my ($self, $env) = @_;

    # нормализуем uri
    my $uri = $env->{REQUEST_URI};
    $uri =~ s/[\?\#].*//;
    $uri = uri_unescape($uri);
    $uri =~ s!/+!/!g;

    if ($self->urlmap) {
        for my $um (@{$self->urlmap}) {
            my ($location, $cmd_info) = @$um;
            $env->{cmd_params} = {};
            if (ref($location) eq 'Regexp') {
                next unless $uri =~ /^$location(?:\/|$)/;
                hash_merge $env->{cmd_params}, {%+};
            } else {
                next unless $location eq '' or $uri =~ /^\Q$location\E(?:\/|$)/;
            }
            # определяем cmd
            if (!ref $cmd_info) {
                    $env->{cmd} = $cmd_info;                
            } elsif (ref($cmd_info) eq 'HASH') {
                if ($cmd_info->{cmd}) {
                    $env->{cmd} = $cmd_info->{cmd};
                } elsif ($cmd_info->{cgi_param}) {
                    my $req = Plack::Request->new($env);
                    $env->{cmd} = $req->param($cmd_info->{cgi_param});
                    $env->{cmd} = $cmd_info->{default} if !defined $env->{cmd};
                } elsif ($cmd_info->{from_url}) {
                    $env->{cmd} = $env->{cmd_params}->{cmd};
                } else {
                    die "Unsupported cmd_info hash";
                }
                if ($cmd_info->{params}) {
                    hash_merge $env->{cmd_params}, $cmd_info->{params};
                }
            } else {
                die "Unsupported cmd_info";
            }
            last;
        }
    }
    if (!defined $env->{cmd}) {
        return [404, [ 'Content-Type' => 'text/plain' ], [ "Not Found" ]];
    }
    return $self->app->($env);
}

1;
