package Plack::Middleware::FakeAuth;
use parent qw/Plack::Middleware/;

# $Id$

use strict;
use warnings;

use URI::Escape qw/uri_unescape/;

use Yandex::Blackbox;
use Yandex::Log;
use Yandex::SendMail;


=head2 fake_auth
    
    Проверка фейковой авторизации
    Смотрим на куку fake_name, ждем там uid или логин

=cut

sub fake_auth
{
    my $env = shift;

    return if !$env->{HTTP_COOKIE} || $env->{HTTP_COOKIE} !~ /fake_name=([^;]+)/;
    my $fake_auth = uri_unescape($1);
    if ($fake_auth =~ /^\S+$/) {
        my $params = {};
        if ($fake_auth =~ /^\d+$/) {
            $params->{uid} = $fake_auth;
        } else {
            $params->{login} = $fake_auth;
        }
        my $bb_res = eval { bb_userinfo($params, '127.0.0.1', 'sprav.yandex.ru', [$BB_LOGIN, $BB_SUID_WEBMASTER]) };
        if ($@) {
            send_alert($@, 'BlackBox error'); 
            die $@;
        }
        if ($bb_res->{uid}) {
            return ($bb_res->{uid}, $bb_res->{dbfield}->{$BB_LOGIN}, $bb_res->{dbfield}->{$BB_SUID_WEBMASTER});
        }
    }
    return;
}


=head2 call

    Коллбэк для Plack::Middleware

=cut

sub call
{
    my ($self, $env) = @_;

    my $log = Yandex::Log->new(log_file_name => 'fake_auth.log');
    my ($fake_uid, $fake_login, $fake_is_webmaster ) = fake_auth($env);
    if ($fake_uid) {
        $env->{real_uid}       = $env->{operator_uid};
        $env->{real_login}     = $env->{operator_login};
        $env->{real_operator_is_webmaster} = $env->{operator_is_webmaster};
        $env->{operator_uid}   = $fake_uid;
        $env->{operator_login} = $fake_login;
        $env->{operator_is_webmaster} = $fake_is_webmaster;
        $log->out("$env->{reqid}\t$env->{real_login} is authenticated as $env->{operator_login}");
    }
    return $self->app->($env);
}

1;
