package Plack::Middleware::MailFatals;
use base qw/Plack::Middleware/;
use Plack::Util::Accessor qw/email subject/;

# $Id$

=head1 NAME

    Plack::Middleware::MailFatals

=head1 DESCRIPTION

    Отправка 500-ых ошибок по почте через Yandex::SendMail

=cut


use strict;
use warnings;

use Yandex::SendMail;

use utf8;

=head2 call

    Коллбэк для Plack::Middleware

=cut

sub call
{
    my ($self, $env) = @_;

    my $response = $self->app->($env);
    
    if ($response->[0] >= 500) {
        my $content = join(
            "\n------------\n"
            , @$env{qw/last_error last_stacktrace/}
            , join("\n", map {$_ . " => " . $env->{$_}} sort grep {/^(HTTP|QUERY|SCRIPT|reqid)/i} keys %$env)
        );
        $content =~ s/^(HTTP_COOKIE.*Session_id=)[^;]+/${1}__HIDDEN__/m;
        send_alert($content, $self->subject || '500 error', $self->email);
        warn join "\n", @$env{qw/last_error last_stacktrace/};
        die "500 error";
    }
    return $response;
}

1;
