package Plack::Middleware::MemLimit;
use base qw/Plack::Middleware/;

use Plack::Util::Accessor qw/limit/;

# $Id$

=head1 NAME

    Plack::Middleware::MemLimit

=head1 DESCRIPTION

    Используем Yandex::MemLimit - после выполнения запроса проверяет количество занимаемой памяти,
    при превышении limit байт виртуальной памяти - перезапускается.

    Работает для серверов, поддерживающих harakiri mode.

    TODO Возможно, стоит использовать Plack::Middleware::SizeLimit вместо этого модуля.

=cut


use strict;
use warnings;

use feature 'state';

use Yandex::ProcInfo;
use POSIX qw/strftime/;

use utf8;


=head2 call

    Коллбэк для Plack::Middleware

=cut

sub call
{
    my ($self, $env) = @_;
    my $res = $self->app->($env);

    return $res unless $env->{'psgix.harakiri'};
    state $req_count = 0;
    $req_count++;

    if ($self->limit > 0) {
        my $size = proc_memory();
        if ($size > $self->limit) {
            my $msize = int($size / 1024 / 1024);
            warn strftime("%Y-%m-%d %H:%M:%S", localtime)." Process [$$".($env->{reqid} ? "/".$env->{reqid} : "")."] too big: rss=${msize}Mb, req_count=$req_count, exit (by Plack::Middleware::MemLimit)\n";
            $env->{'psgix.harakiri.commit'} = 1;
        }
    }
    return $res;
}

1;
