package Plack::Middleware::Profile;

use Carp qw/croak/;

use base qw/Plack::Middleware/;

use Plack::Util::Accessor qw/cmd_type cmd/;

# $Id$

=head1 NAME

    Plack::Middleware::Profile

=head1 DESCRIPTION

    Используем Yandex::Profile - в начале запроса создаём script_timer, по окончанию работы 
    сбрасываем строчку в profile.log

    Если в env есть cmd или reqid - указываем их при создании таймера.

=cut


use strict;
use warnings;

use Yandex::Profile;

use utf8;


=head2 call

    Коллбэк для Plack::Middleware

=cut

sub call
{
    my ($self, $env) = @_;
    my $name = ($self->cmd_type || 'unknown') . "/" . ($env->{cmd} || $self->cmd || 'unknown');
    $env->{script_timer} = script_timer($name => $env->{reqid} || undef);
    my $res = $self->app->($env);
    if (ref($res) eq 'ARRAY') {
        delete $env->{script_timer};
        return $res;
    } elsif (ref($res) eq 'CODE') {
        # в случае стриминга - будем разрушать таймер только после отдачи всех данных
        return sub {
            $res->(@_);
            delete $env->{script_timer};
        };
    } else {
        croak "Unsupported response type: ".ref($res);
    }
}

1;
