package Plack::Middleware::ProfileSOAP;
use base qw/Plack::Middleware/;

use Plack::Util::Accessor qw/cmd_type cmd/;

# $Id$

=head1 NAME

    Plack::Middleware::Profile

=head1 DESCRIPTION

    Аналогично Plack::Middleware::Profile, но для SOAP-запросов (более детально разбирается команда).
    Тип для таймера -- из параметров, команда -- из SOAPAction.

    Используем Yandex::Profile - в начале запроса создаём script_timer, по окончанию работы 
    сбрасываем строчку в profile.log


=cut


use strict;
use warnings;

use Yandex::Profile;
use Plack::UTF8Request;

use utf8;


=head2 call

    Коллбэк для Plack::Middleware

=cut

sub call
{
    my ($self, $env) = @_;
    my $r = Plack::UTF8Request->new($env);
    $r->headers->header('SOAPAction') =~ /#(\w+)/;
    my $soap_action = $1 || $env->{cmd} || 'unknown';
    my $name = ($self->cmd_type || 'unknown') . "/" . $soap_action;
    $env->{script_timer} = script_timer($name => $env->{reqid} || undef);
    my $res = $self->app->($env);
    return $res;
}

1;
