package Plack::Middleware::Reqid;
use base qw/Plack::Middleware/;

# $Id$

=head1 NAME

    Plack::Middleware::Reqid

=head1 DESCRIPTION

    Добавляем в $env уникальный идентификатор запроса reqid

=cut


use strict;
use warnings;

use Time::HiRes;

use utf8;


=head2 call

    Коллбэк для Plack::Middleware

=cut

sub call
{
    my ($self, $env) = @_;
    $env->{reqid} = generate_reqid();
    return $self->app->($env);
}


=head2 generate_reqid

    Сгенерировать уникальное 64-х битное целое неотрицательное числот - reqid

=cut

sub generate_reqid 
{
    return( (Time::HiRes::time()*256 % 2**32) * 2**32 + $$ * 2**16 + int(rand(2**16)) );
}

1;
