package Plack::Middleware::Trace;

use Carp qw/croak/;

use base qw/Plack::Middleware/;

use Plack::Util::Accessor qw/cmd_type cmd use_headers/;

=head1 NAME

    Plack::Middleware::Trace

=head1 DESCRIPTION

    Используем Yandex::Trace - в начале запроса создаём trace(), по окончанию работы 
    уничтожаем объект

    Если в env есть cmd -- используем при создании таймера.

=cut


use strict;
use warnings;
use utf8;

use Yandex::Trace;
use Plack::UTF8Request;

=head2 call

    Коллбэк для Plack::Middleware

=cut

sub call
{
    my ($self, $env) = @_;
    my $r = Plack::UTF8Request->new($env);
    my ($soap_action) = ($r->headers->header('SOAPAction')//'') =~ /#(\w+)/;
    my $name = $soap_action || $env->{cmd} || $self->cmd || 'unknown';
    if ($self->use_headers) {
        $env->{trace} = Yandex::Trace::new_from_http_headers($r->headers, service => $self->cmd_type || 'unknown', method => $name);
    }
    else {
        $env->{trace} = Yandex::Trace->new(service => $self->cmd_type || 'unknown', method => $name);
    }
    $env->{reqid} = $env->{trace}->current_span_id();
    my $res = $self->app->($env);
    if (ref($res) eq 'ARRAY') {
        delete $env->{trace};
        return $res;
    } elsif (ref($res) eq 'CODE') {
        # в случае стриминга - будем разрушать таймер только после отдачи всех данных
        return sub {
            $res->(@_);
            delete $env->{trace};
        };
    } else {
        croak "Unsupported response type: ".ref($res);
    }
}

1;

