package Plack::Middleware::Usertrack;
use parent qw/Plack::Middleware/;

# $Id$

=head1 NAME

    Plack::Middleware::Usertrack

=head1 DESCRIPTION

    Функциональность mod_usertrack

=cut


use strict;
use warnings;

use Plack::Request;
use Plack::Response;
use Plack::Util::Accessor qw/CookieDomain CookieName CookieExpires generator/;
use Time::HiRes;

use utf8;


=head2 call

    Коллбэк для Plack::Middleware

=cut

sub call
{
    my ($self, $env) = @_;

    my $req = Plack::Request->new($env);
    my $app_response = $self->app->($env);
    if ($req->cookies->{$self->CookieName}) {
        return $app_response;
    } else {
        my $res = Plack::Response->new(@$app_response);
        $res->cookies->{$self->CookieName} = {
            value   => ($self->generator ? $self->generator->($req) : _default_generator($req)),
            path    => '/',
            expires => time + ($self->CookieExpires || 315360000),
        };
        my $domain = ref $self->CookieDomain eq 'CODE' ? $self->CookieDomain->($env) : $self->CookieDomain;
        if ($domain) {
            $res->cookies->{$self->CookieName}->{domain} = $domain;
        }
        return $res->finalize;
    }
}


=head2 _default_generator($req)

    Стандартный способ генерации значения

=cut

sub _default_generator
{
    my $req = shift;

    my ($secs, $msecs) = Time::HiRes::gettimeofday;
    $msecs /= 1000;
    return $req->address.'.'.$$.$secs.int($msecs);
}

1;
