package Plack::NormalizeResponse;

# $Id$

=head1 NAME

    Plack::Middleware::TransformResponse

=head1 DESCRIPTION

    Преобразование Geocontext-style ответа в стандартный Plack'овский массив

    Поддерживаются типы ответов: 
    coderef -- ссылка на функцию (надо для Delayed Reponse and Streaming Body), возвращается как есть,
    plack -- ссылка на массив, возвращается как есть

    Хеши
    json  -- ссылка на хеш с ключом json. Значение по этому ключу сериализуется
    text  -- ссылка на хеш с ключом text
    template -- ссылка на хеш с ключом template. 
        Обрабатывается шаблон template с переменными по ключу vars. 
        Для создания (персистентного) объекта TT используется функция, 
        ссылка на которую находится в переменной $get_tt_obj. 
        Заполнить эту переменную -- ответственность пользователя модуля.

    Кроме контента, в хеше могут присутствовать: 
        content_type, по умолчанию подходящий ('application/json; charset=utf-8' или 'text/plain; charset=utf-8')
        code, по умолчанию 200

=cut


use strict;
use warnings;

use Data::Dumper;
use List::Util qw{ first };
use Encode;
use JSON::XS;

use Yandex::Profile;

use utf8;

=head2 json

    copy-paste из geocontext.yandex.ru.psgi

=cut
{
    my $json;
    sub json {
        return $json ||= JSON::XS->new->utf8;
    }
}

my $template;

our $get_tt_obj;

my %transform = (
    json => sub {
        my $response = shift;

        my $res = Plack::Response->new($response->{code} || 200);
        $res->content_type($response->{content_type} || 'application/json; charset=utf-8');
        $res->body(json->encode($response->{json}));
        return $res->finalize;
    },
    text => sub {
        my $response = shift;

        my $res = Plack::Response->new($response->{code} || 200);
        $res->content_type($response->{content_type} || 'text/plain; charset=utf-8');
        $res->body( encode 'utf8', $response->{text} );
        return $res->finalize;
    },
    data => sub {
        my $response = shift;

        my $res = Plack::Response->new($response->{code} || 200);
        $res->content_type($response->{content_type} || 'data/binary');
        $res->body( $response->{data} );
        return $res->finalize;
    }, 
    # Непотестированный вариант, использовать с осторожностью
    template => sub {
        my $response = shift;

        my $body;
        $template->process($response->{template}, $response->{vars}, \$body) or die $template->error();
        my $res = Plack::Response->new($response->{code} || 200);
        $res->content_type('text/html; charset=utf-8');
        $res->body(Encode::encode_utf8($body));
        return $res->finalize;
    },
    # TODO xml, redirect
);


=head2 normalize

    фрагмент из geocontext.yandex.ru.psgi

=cut
sub normalize
{
    my ($response) = @_;

    return $response if (ref $response) =~ /^(CODE|ARRAY)$/;

    my $response_type = first { exists $response->{$_} } keys %transform or die "unknown response type";

    my $t = timer(type => $response_type);

    return $transform{$response_type}->($response);
}


1;
