# -*- coding: utf-8 -*-

import psycopg2
from ppcinv.helpers import *

import logging
logging.getLogger(__name__).addHandler(logging.NullHandler())

class PPCInvPsqlStorage(object):

    def __init__(self, connect_kwargs):
        self.logger = logging.getLogger(__name__)
        self.conn = psycopg2.connect(**connect_kwargs)
        self.conn.set_session(autocommit=True)
        self.cur = self.conn.cursor()

    def __del__(self):
        self.cur.close()
        self.conn.close()


    def load_hosts(self, cluster_conf):
        columns = ["bot_fqdn", "bot_id", "cluster_name", "conductor_group_id", "conductor_group_name", "cpu_cores_guarantee", "cpu_cores_limit", "fqdn", "gencfg_group_name", "gencfg_hbf_backbone_fqdn", "gencfg_old_launcher_fqdn", "gencfg_release", "host_cpu_cores", "host_memory_gb", "location", "memory_guarantee_gb", "nanny_service_name", "platform_environment_path", "pos_in_cluster", "project_name", "ready", "root_dc", "source", "ya_environment_name",]

        query = 'select ' + ', '.join(columns) + ' from ppcinv_hosts where project_name = %(project_name)s and ya_environment_name = %(ya_environment_name)s and cluster_name = %(cluster_name)s'
        #self.logger.debug('Execute query: ' + self.cur.mogrify(query, cluster_conf))
        self.cur.execute(query, cluster_conf)

        hosts_data = []
        for values in self.cur:
            host_data = dict(zip(columns, values))
            #self.logger.debug('Fetched values: %s, host_data: %s' % (values, json.dumps(host_data, sort_keys=True)))
            hosts_data.append(host_data)

        return hosts_data


    def update_hosts(self, hosts_data):
        for data in hosts_data:
            columns = sorted(data.keys())
            placeholders = []
            values = []
            for k in columns:
                values.append(data[k])
                placeholders.append('%s')

            non_pkey_columns = [ x for x in columns if x not in ['project_name', 'ya_environment_name', 'cluster_name', 'pos_in_cluster']]
            update_params = []
            for c in non_pkey_columns:
                update_params.append('%s = EXCLUDED.%s' % (c, c)) 

            query = 'insert into ppcinv_hosts (' + ', '.join(columns) + ') values (' + ', '.join(placeholders) + ') on conflict on constraint ppcinv_hosts_pkey do update set ' + ', '.join(update_params)
            #self.logger.debug('Execute query: ' + self.cur.mogrify(query, values))
            self.cur.execute(query, values)
    
    
    def delete_hosts(self, hosts_data):
        for host_data in hosts_data:
            query = 'delete from ppcinv_hosts where project_name = %(project_name)s and ya_environment_name = %(ya_environment_name)s and cluster_name = %(cluster_name)s and pos_in_cluster = %(pos_in_cluster)s'
            #self.logger.debug('Execute query: ' + self.cur.mogrify(query, host_data))
            self.cur.execute(query, host_data)


    def merge_hosts(self, merge_actions):
        self.delete_hosts(merge_actions['delete'])
        self.update_hosts(merge_actions['add'] + merge_actions['update'])

###class DbConnection(object):
###
###    def __init__(self):
###        self.conn = psycopg2.connect("dbname=tabula")# user=ppc port=12000 host=pgaas.mail.yandex.net")
###        self.conn.set_session(autocommit=True)
###        self.cur = self.conn.cursor()
###
###    def __del__(self):
###        self.cur.close()
###        self.conn.close()

###def get_cluster_hosts_data(cluster_name):
###    hosts_data = []
###
###    db = DbConnection()
###    keys = ('project_name', 'project_id', 'cluster_name', 'cluster_id', 'pos_in_cluster', 'nanny_service_name', 'nanny_service_id', 'platform_environment_path', 'gencfg_group_name', 'gencfg_group_id', 'gencfg_release', 'conductor_group_name', 'conductor_group_id', 'bot_fqdn', 'bot_id', 'location', 'root_dc', 'fqdn', 'host_id', 'cpu_cores_guarantee', 'cpu_cores_limit', 'memory_guarantee_gb')
###    db.cur.execute("""SELECT p.project_name, p.project_id, c.cluster_name, c.cluster_id, h.pos_in_cluster, ns.nanny_service_name, ns.nanny_service_id, ns.platform_environment_path, gg.gencfg_group_name, gg.gencfg_group_id, gg.gencfg_release, cg.conductor_group_name, cg.conductor_group_id, bh.bot_fqdn, bh.bot_id, bh.location, bh.root_dc, h.fqdn, h.host_id, h.cpu_cores_guarantee, h.cpu_cores_limit, h.memory_guarantee_gb from ppcinv_hosts h INNER JOIN ppcinv_clusters c on h.cluster_id = c.cluster_id INNER JOIN ppcinv_projects p on c.project_id = p.project_id INNER JOIN ppcinv_bot_hosts bh on h.bot_id = bh.bot_id INNER JOIN ppcinv_nanny_services ns on h.nanny_service_id = ns.nanny_service_id INNER JOIN ppcinv_gencfg_groups gg on h.gencfg_group_id = gg.gencfg_group_id INNER JOIN ppcinv_conductor_groups cg on h.conductor_group_id = cg.conductor_group_id WHERE cluster_name = %s ORDER BY project_name, cluster_name, pos_in_cluster, fqdn""", (cluster_name,))
###    data = db.cur.fetchall()
###
###    for row in data:
###        host_data = {}
###        for i in range(0, len(keys)):
###            host_data[keys[i]] = row[i]
###        hosts_data.append(host_data)
###
###    return hosts_data
###
###
#### TODO: on conflict do nothing - не полагаться на constraints бд =(
###def get_or_create_project(name):
###    db = DbConnection()
###    db.cur.execute("""insert into ppcinv_projects (project_name) values (%s) on conflict do nothing""", (name,))
###    db.cur.execute("""select project_id from ppcinv_projects where project_name = %s""", (name,))
###    id = db.cur.fetchone()[0]
###    return id
###
###
###def get_or_create_gencfg_group(name, release):
###    db = DbConnection()
###    db.cur.execute("""insert into ppcinv_gencfg_groups (gencfg_group_name, gencfg_release) values (%s, %s) on conflict do nothing""", (name, release))
###    db.cur.execute("""select gencfg_group_id from ppcinv_gencfg_groups where gencfg_group_name = %s""", (name,))
###    id = db.cur.fetchone()[0]
###    return id
###
###
###def get_or_create_conductor_group(name, conductor_group_id):
###    db = DbConnection()
###    db.cur.execute("""insert into ppcinv_conductor_groups (conductor_group_id, conductor_group_name) values (%s, %s) on conflict do nothing""", (conductor_group_id, name))
###    return conductor_group_id
###
###
###def get_or_create_bot_host(fqdn, location, root_dc, bot_id):
###    db = DbConnection()
###    db.cur.execute("""insert into ppcinv_bot_hosts (bot_id, bot_fqdn, location, root_dc) values (%s, %s, %s, %s) on conflict do nothing""", (bot_id, fqdn, location, root_dc))
###    return bot_id
###
###
###def get_or_create_nanny_service(name, platform_env_id, cluster_id):
###    db = DbConnection()
###    db.cur.execute("""insert into ppcinv_nanny_services (nanny_service_name, platform_environment_path, cluster_id) values (%s, %s, %s) on conflict do nothing""", (name, platform_env_id, cluster_id))
###    db.cur.execute("""select nanny_service_id from ppcinv_nanny_services where nanny_service_name = %s""", (name,))
###    id = db.cur.fetchone()[0]
###    return id
###
###
###def get_or_create_cluster(name, project_id):
###    db = DbConnection()
###    db.cur.execute("""insert into ppcinv_clusters (cluster_name, project_id) values (%s, %s) on conflict do nothing""", (name, project_id))
###    db.cur.execute("""select cluster_id from ppcinv_clusters where cluster_name = %s and project_id = %s""", (name, project_id))
###    id = db.cur.fetchone()[0]
###    return id
###
###
###def get_or_create_host(fqdn, cluster_id, bot_id, nanny_service_id, gencfg_group_id, conductor_group_id, cpu_cores_guarantee, cpu_cores_limit, memory_guarantee_gb):
###    db = DbConnection()
###    db.cur.execute("""select * from ppcinv_hosts where fqdn = %s and cluster_id = %s""", (fqdn, cluster_id))
###    data = db.cur.fetchone()
###    if data and len(data) and data[1] == fqdn:
###        return data
###
###    db.conn.set_session(autocommit=False)
###    db.cur.execute("""select pos_in_cluster from ppcinv_hosts where cluster_id = %s""", (cluster_id,))
###    pos_in_cluster = get_next_position(db.cur.fetchall())
###
###    db.cur.execute("""insert into ppcinv_hosts (fqdn, cluster_id, pos_in_cluster, bot_id, nanny_service_id, gencfg_group_id, conductor_group_id, cpu_cores_guarantee, cpu_cores_limit, memory_guarantee_gb) values (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s)""", (fqdn, cluster_id, pos_in_cluster, bot_id, nanny_service_id, gencfg_group_id, conductor_group_id, cpu_cores_guarantee, cpu_cores_limit, memory_guarantee_gb))
###    db.conn.commit()
###    db.conn.set_session(autocommit=True)
###
###    db.cur.execute("""select host_id from ppcinv_hosts where fqdn = %s and cluster_id = %s""", (fqdn, cluster_id))
###    id = db.cur.fetchone()[0]
###    return id


