# -*- coding: utf-8 -*-

import tempfile
import subprocess
from subprocess import Popen, PIPE
# import xml.etree.ElementTree as ET
# from collections import deque
from ppcinv.helpers import *

import logging
logging.getLogger(__name__).addHandler(logging.NullHandler())

#def svn_get_unversioned(path):
#    cmd = ['svn', 'status', '--xml', path]
#    status_xml = subprocess.check_output(cmd)
#    status_tree = ET.fromstring(status_xml)
#
#    unversioned = []
#    elem_q = deque(status_tree)
#
#    cur_path = None
#    while elem_q:
#        elem = elem_q.pop()
#        ## print "tag: %s\tattr: %s\tpath: %s" % (elem.tag, str(elem.attrib), cur_path)
#
#        if elem.tag == 'wc-status' and elem.attrib.get('item', '') == 'unversioned' and cur_path:
#            unversioned.append(cur_path)
#            cur_path = None
#        elif elem.tag == 'entry':
#            cur_path = elem.attrib.get('path')
#        else:
#            cur_path = None
#
#        elem_q.extend(elem)
#
#    return unversioned
#
#
#def svn_reset_db():
#    logger = logging.getLogger(__name__)
#
#    svn_info = subprocess.check_output(['svn', 'info', SVN_DB_PATH]).split('\n')
#    svn_info = { kv[0]: kv[-1] for kv in [ x.split(': ', 2) for x in svn_info ]}
#
#    cmd = ['svn', 'revert', '--recursive', SVN_DB_PATH]
#    logger.debug('run cmd: ' + ' '.join(cmd))
#    subprocess.check_call(cmd)
#
#    unversioned = svn_get_unversioned(SVN_DB_PATH)
#    logger.debug('run cmd: rmtree ' + SVN_DB_PATH)
#    rmtree_full(*unversioned)
#
#    cmd = ['svn', 'checkout', svn_info['URL'] + '@' + svn_info['Last Changed Rev'], SVN_DB_PATH]
#    logger.debug('run cmd: ' + ' '.join(cmd))
#    subprocess.check_call(cmd)

class PPCInvSvnStorage(object):

    def __init__(self, db_path, svn_user, svn_scheme, svn_host, svn_path, cleanup_existing=False): #, tmp_prefix='ppcinv-tmp-svn-db', tmp_dir=None, cleanup_tmp=True):
        self.db_path = db_path
        self.svn_url = svn_scheme + '://' + svn_user + '@' + svn_host + '/' + svn_path
#        self.tmp_prefix = tmp_prefix
#        self.tmp_dir = tmp_dir
#        self.cleanup_tmp = cleanup_tmp
#        self.tmp_dir_created = False
        self.logger = logging.getLogger(__name__)

#        if not self.db_path:
#            try:
#                self.db_path = tempfile.mkdtemp(prefix=self.tmp_prefix, dir=self.tmp_dir)
#            except Exception as e:
#                self.logger.error('Cannot create tmp dir for svn db: %s - %s' % (type(e), e))
#                raise
#            self.tmp_dir_created = True
#            self.logger.debug('Temp dir for svn db created: ' + self.db_path)
        if cleanup_existing:
            self.logger.debug('Cleanup svn db: ' + self.db_path)
            rmtree_full(self.db_path)
    
        cmd = ['svn', 'checkout', self.svn_url, self.db_path]
        self.logger.debug('run cmd: ' + ' '.join(cmd))

        devnull = open(os.devnull, 'w')
        subprocess.check_call(cmd, stdout=devnull)


#    def __del__(self):
#        if self.tmp_dir_created and self.cleanup_tmp:
#            rmtree_full(self.db_path)
#            self.logger.info('Removed: ' + self.db_path)


    def load_clusters(self):
        clusters_path = os.path.join(self.db_path, 'clusters.json')
        if not os.path.exists(clusters_path):
            return []
    
        with open(clusters_path, 'r') as f:
            return json.load(f)


    def update_clusters(self, data):
        clusters_path = os.path.join(self.db_path, 'clusters.json')
    
        with open(clusters_path, 'w+') as f:
            json.dump(data, f, sort_keys=True, indent=4, separators=(',', ': '), ensure_ascii=True)
    
    
    def load_hosts(self, cluster_conf):
        cluster_path = os.path.join(self.db_path, *get_cluster_path_list(cluster_conf))
        hosts_data = []
        if not os.path.exists(cluster_path):
            return hosts_data
    
        for host_alias in os.listdir(cluster_path):
            try:
                host_alias = check_host_alias(host_alias, cluster_conf)
            except Exception as e:
                self.logger.debug('Bad host alias in %s: %s' % (cluster_path, str(e)))
                continue
 
            host_path = os.path.join(cluster_path, host_alias)
            self.logger.debug('Read host alias ' + host_path)
            with open(host_path, 'r') as f:
                host_data = json.load(f)
                hosts_data.append(host_data)
    
        return hosts_data
    
    
    def update_hosts(self, hosts_data):
        for host_data in hosts_data:
            cluster_path = os.path.join(self.db_path, *get_cluster_path_list(host_data))
            host_path = os.path.join(self.db_path, *get_host_path_list(host_data))
    
            if not os.path.exists(cluster_path):
                os.makedirs(cluster_path)
            with open(host_path, 'w+') as f:
                json.dump(host_data, f, sort_keys=True, indent=4, separators=(',', ': '))
    
            cmd = ['svn', 'add', '--force', '--parents', host_path]
            self.logger.debug('run cmd: ' + ' '.join(cmd))
            p = Popen(cmd, stdout=PIPE, stderr=PIPE, cwd=self.db_path)
            out, err = p.communicate()
            self.logger.debug('cmd finished with retcode: %s out: %s err: %s' % (p.returncode, out, err))
    
    
    def delete_hosts(self, hosts_data):
        for host_data in hosts_data:
            host_path = os.path.join(self.db_path, *get_host_path_list(host_data))
    
            cmd = ['svn', 'delete', host_path]
            self.logger.debug('run cmd: ' + ' '.join(cmd))
            p = Popen(cmd, stdout=PIPE, stderr=PIPE, cwd=self.db_path)
            out, err = p.communicate()
            self.logger.debug('cmd finished with retcode: %s out: %s err: %s' % (p.returncode, out, err))
            #os.remove(host_path)
            # TODO: удалять пустые директории
    
    
    def merge_hosts(self, merge_actions):
        self.delete_hosts(merge_actions['delete'])
        self.update_hosts(merge_actions['add'] + merge_actions['update'])
