#!/usr/bin/env perl
use strict;
use warnings;

my $apply = ($ARGV[0] // "undef") eq "--apply";

open(my $fh, "-|", "ps -e -o user,rss,pid,cmd") or die $!;

my %stale_betas;

while (<$fh>) {
    my ($user, $rss, $pid, $cmd) = (/^(\S+)\s+(\d+)\s+(\d+)\s+(.*)/);
    next unless $user || $rss || $pid || $cmd;

    my ($beta) = ($cmd =~ /(\bbeta\.[\w-]+\.\d+)/);
    next unless $beta;
    if (! -d "/var/www/$beta") {
        push @{$stale_betas{$beta}}, $pid;
    }
}

if (! %stale_betas) {
    print "OK - no stale betas found\n";
    exit 0;
}

while (my ($beta, $pids) = each %stale_betas) {
    my $pids_str = join " ", @$pids;
    printf "stale beta, dir /var/www/$beta not found, %s %s\n", $apply ? "going to run: kill" : "run with --apply to kill pids:", $pids_str;
    qx(kill $pids_str) if $apply;
}
