#!/usr/bin/env perl

# $Id$

=head1 NAME

=encoding utf8

old_apaches - найти запущенные apache, на которые никто не ходит

=head1 DESCRIPTION

    Найти беты, на которых запущены apache, при этом access.log не обновляется; вывести их список

    Опции:
    --days=N
        сколько дней должен не обновляться access.log, чтобы бета появилась в списке

=cut

use strict;
use warnings;
use utf8;
use open ':std' => ':utf8';
use Getopt::Long;
use POSIX qw/strftime/;

my $SECONDS_IN_A_DAY = 60 * 60 * 24;
my $epoch_time = time();
my $DAYS = 0.5;

GetOptions(
    "help" => sub {system("podselect -section NAME -section DESCRIPTION $0 | pod2text >&2"); exit 0;},
    "days=f" => \$DAYS,
) or die "can't parse options";
die "days must be positive" unless ($DAYS > 0);
my $TIME = $epoch_time - $SECONDS_IN_A_DAY * $DAYS;

my $PS = `ps aux | grep sbin/apache`;

my $base = '/var/www';
opendir(D, $base) || die "Can't read dir $base";
my @dirs = grep {-d "$base/$_"} grep {/^[\w\.\-]+$/} readdir(D);
my @betas;
$, = "\n";

for my $dir (@dirs) {
    my $text = `LC_ALL=C svn info $base/$dir 2>&1`;
    my ($url) = $text =~ /^URL:\s+(.*)/m;
    next unless ($url && $url =~ m!/direct/!);
    my ($rev) = $text =~ /^Revision:\s+(.*)/m;
    if ($PS =~ $dir) {
        my $log_path = "$base/$dir/apache/logs/access.log";

        if (!-f $log_path) {
            $log_path = "$base/$dir";
        }

        if (-f $log_path) {
            my $mtime = `stat -c %Y $log_path`;
            chomp $mtime;
            if ($mtime && $mtime =~ /^\d+$/ && $mtime >= $TIME) {
                next;
            }
        }

        push @betas, "$base/$dir";
    }
}

@betas = sort @betas;
print @betas;
